/**
 * \file    dia_SrvHandlerGenericIdentWrite.h
 *
 * \brief   This file contains the definition of the dia_SrvHandlerGenericIdentWrite class,
 *          that provides a generic service handler that can be used to process
 *          write requests for the ConfigManager.
 *
 * \author  shw2abt
 * \date    2012/05/04 
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#ifndef dia_SrvHandlerGenericIdentWrite_H_
#define dia_SrvHandlerGenericIdentWrite_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

/**
 * \class   dia_SrvHandlerGenericIdentWrite
 *
 * \brief   Generic service handler to process Identification request
 *
 *          This class provides a generic service handler that can be used to process
 *          identification requests that need to write one or more properties into
 *          the ConfigManager module.
 *
 * \ingroup diaServicesCommon
 */

class dia_SrvHandlerGenericIdentWrite
    : public dia_ServiceHandlerUDS
{
   friend class dia_UTServiceHandlerGenericIdentWrite;
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerGenericIdentWrite);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericIdentWrite);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandlerGenericIdentWrite ( tCString name, tU8 sid, tU8 did );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    */
   dia_SrvHandlerGenericIdentWrite ( tCString name, tU8 sid, tU16 did );

   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandlerGenericIdentWrite ( void );

   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    *
    * \return     none
    */
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

protected:
   //! validate incoming data for proper length and format
   virtual tDiaResult validateData ( const tU8 /*data*/[], tU16 /*len*/  ) { return DIA_SUCCESS; }
   //! check if length is inside of the given range
   virtual tDiaResult checkLength ( tU16 length, tU16 minValue, tU16 maxValue );
   //! check for ASCII values in the given range
   virtual tDiaResult checkASCII ( const tU8 data[], tU16 length, tU16 offset, tU16 count );
   //! check for BCD values in the given range
//   virtual tDiaResult checkBCD ( const tU8 data[], tU16 length, tU16 offset, tU16 count );
   //! check for zero termination
   virtual tDiaResult checkZeroTerminated ( const tU8 data[], tU16 length );
};

#endif /* dia_SrvHandlerGenericIdentWrite_H_ */
