/**
 * \file    dia_SrvHandlerGenericIdentReadWithDefaults.h
 *
 * \brief   This file contains the definition of the dia_SrvHandlerGenericIdentReadWithDefaults class
 *          that extends class dia_SrvHandlerGenericIdentRead with a default value
 *
 * \author  gib2hi
 * \date    2015/06/12
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_SERVICE_HANDLER_GENERIC_IDENT_READ_WITH_DEFAULTS__
#define __INCLUDED_SERVICE_HANDLER_GENERIC_IDENT_READ_WITH_DEFAULTS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_SERVICE_HANDLER_GENERIC_IDENT_READ__
#include <common/services/uds/generic/dia_SrvHandlerGenericIdentRead.h>
#endif

/**
 * \class   dia_SrvHandlerGenericIdentReadWithDefaults
 *
 * \brief   Generic service handler to process Identification request
 *
 *          This class provides a generic service handler that can be used to process
 *          identification requests that need to read a single property from
 *          the ConfigManager module. In case the property is not available a default
 *          value shall be returned
 *
 * \ingroup diaServicesCommon
 */

class dia_SrvHandlerGenericIdentReadWithDefaults
    : public dia_SrvHandlerGenericIdentRead
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerGenericIdentReadWithDefaults);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericIdentReadWithDefaults);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU8 did );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU16 did );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU8 did, dia_PROPID propertyID );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    */
   dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU16 did, dia_PROPID propertyID );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU8 did, const tU8 defaultData[], tU16 dataLength );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    */
   dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU16 did, const tU8 defaultData[], tU16 dataLength  );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU8 did, const std::vector<tU8>& defaultData );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    */
   dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU16 did, const std::vector<tU8>& defaultData  );

   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandlerGenericIdentReadWithDefaults ( void );
   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  pArname     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    *
    * \return     none
    */
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );


protected:
   //! default data to be returned in case that the data does not exist
   std::vector<tU8> mDefaultData;
   //!
   bool mIsDefaultDataAvailable;
};

#endif /* __INCLUDED_SERVICE_HANDLER_GENERIC_IDENT_READ_WITH_DEFAULTS__ */
