/*
 * dia_SrvHandlerGenericIdentReadWithDefaults.cpp
 *
 *  Created on: 12.06.2015
 *      Author: gib2hi
 */

/*
 * dia_SrvHandlerGenericIdentReadWithDefaults.cpp
 *
 *  Created on: 12.06.2015
 *      Author: gib2hi
 */

// TTFis: DIA_REQ UDS 03 22 00 47
// TTFis: DIA_REQ GMLAN 02 1A 42

#include "dia_SrvHandlerGenericIdentReadWithDefaults.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))

using namespace dia;
//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU8 did )
   : dia_SrvHandlerGenericIdentRead(name,sid,(tU8) did),
     mIsDefaultDataAvailable(false)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults(tCString,tU8,tU8)");
   mDefaultData.clear();
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU16 did )
   : dia_SrvHandlerGenericIdentRead(name,sid,(tU16) did),
     mIsDefaultDataAvailable(false)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults(tCString,tU8,tU8)");
   mDefaultData.clear();
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU8 did, dia_PROPID propertyID )
   : dia_SrvHandlerGenericIdentRead(name,sid,(tU8) did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults(tCString,tU8,tU8,dia_PROPID)");
   mIsDefaultDataAvailable = ( dia_getProperty(propertyID,mDefaultData) == DIA_SUCCESS ) ? true : false;
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU16 did, dia_PROPID propertyID )
   : dia_SrvHandlerGenericIdentRead(name,sid,(tU16) did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults(tCString,tU8,tU16,dia_PROPID)");
   mIsDefaultDataAvailable = ( dia_getProperty(propertyID,mDefaultData) == DIA_SUCCESS ) ? true : false;
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU8 did, const std::vector<tU8>& defaultData )
   : dia_SrvHandlerGenericIdentRead(name,sid,(tU8) did),
     mDefaultData(defaultData),
     mIsDefaultDataAvailable(true)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults(tCString,tU8,tU8,const std::vector<tU8>&)");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU16 did, const std::vector<tU8>& defaultData )
   : dia_SrvHandlerGenericIdentRead(name,sid,(tU16) did),
     mDefaultData(defaultData),
     mIsDefaultDataAvailable(true)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults(tCString,tU8,tU16,const std::vector<tU8>&)");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU8 did, const tU8 defaultData[], tU16 dataLength )
   : dia_SrvHandlerGenericIdentRead(name,sid,(tU8) did),
     mIsDefaultDataAvailable(true)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults(tCString,tU8,tU8,const std::vector<tU8>&)");
   mDefaultData.insert(mDefaultData.end(), &defaultData[0], &defaultData[dataLength]);
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults ( tCString name, tU8 sid, tU16 did, const tU8 defaultData[], tU16 dataLength )
   : dia_SrvHandlerGenericIdentRead(name,sid,(tU16) did),
     mIsDefaultDataAvailable(true)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentReadWithDefaults::dia_SrvHandlerGenericIdentReadWithDefaults(tCString,tU8,tU16,const std::vector<tU8>&)");
   mDefaultData.insert(mDefaultData.end(), &defaultData[0], &defaultData[dataLength]);
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentReadWithDefaults::~dia_SrvHandlerGenericIdentReadWithDefaults ( void )
{}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerGenericIdentReadWithDefaults::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentReadWithDefaults::vOnProcessRequest");

   // data length contains at least sid, ctrl byte and DID --> 4 bytes minimum
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + 1) ) // one additional byte contains the message length
   {
      DIA_TR_INF("INVALID DATA LENGTH. EXPECTED %d BYTES BUT RECEIVED %d BYTES !!", (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+1),dataLength);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   if ( !vecArgs.size() )
   {
      DIA_TR_INF("UNABLE TO READ ITEM (PROPERTY NOT PASSED AS PARAMETER");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      return;
   }

   tU32 propID = VoidCast<tU32>(vecArgs[0]);

   // read data from persistent memory
   std::vector<tU8> dataVec;
   tDiaResult retCode = dia_getProperty(propID,dataVec);
   if ( retCode == DIA_SUCCESS )
   {
      // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + dataVec.size()));
      for ( tU16 i = 0; i < dataVec.size(); ++i )
      {
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + i), dataVec[i]);
      }

      vResReadyAndQuit();
   }
   else
   {
      if ( mIsDefaultDataAvailable )
      {
         // Sending back the positive answer
         oDiagMsgBuffer().vSetPosResp();
         oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + mDefaultData.size()));
         for ( tU16 i = 0; i < mDefaultData.size(); ++i )
         {
            (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + i), mDefaultData[i]);
         }

         vResReadyAndQuit();
      }
      else
      {
         DIA_TR_INF("UNABLE TO READ ITEM (READ OPERATION FAILED) !!");
         vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      }
   }
}

