/*
 * dia_SrvHandlerGenericIdentRead.cpp
 *
 *  Created on: 27.04.2012
 *      Author: gib2hi
 */

// TTFis: DIA_REQ UDS 03 22 00 47
// TTFis: DIA_REQ GMLAN 02 1A 42

#include "dia_SrvHandlerGenericIdentRead.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))

using namespace dia;

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentRead::dia_SrvHandlerGenericIdentRead ( tCString name, tU8 sid, tU8 did )
   : dia_ServiceHandlerUDS(name,sid,(tU8) did)
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentRead::dia_SrvHandlerGenericIdentRead(tCString,tU8,tU8)");
#endif
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentRead::dia_SrvHandlerGenericIdentRead ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentRead::dia_SrvHandlerGenericIdentRead(tCString,tU8,tU16)");
#endif
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentRead::~dia_SrvHandlerGenericIdentRead ( void )
{}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerGenericIdentRead::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentRead::vOnProcessRequest");

   // data length contains at least sid, ctrl byte and DID --> 4 bytes minimum
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + 1) ) // one additional byte contains the message length
   {
      DIA_TR_INF("dia_SrvHandlerGenericIdentRead::vOnProcessRequest INVALID LENGTH. EXPECTED %d B BUT RECEIVED %d B !", (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+1), dataLength);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   if ( vecArgs.size() )
   {
      tU32 propID = VoidCast<tU32>(vecArgs[0]);

      // data memory
      std::vector<tU8> dataVec;

      // retrieve size of property
      auto length = dia_getPropertySize(propID); //DIA_PROP_LENGTH_MAX;
      dataVec.reserve(length);
      dataVec.resize(length);

      DIA_TR_INF("dia_SrvHandlerGenericIdentRead::vOnProcessRequest - length %zu, dataVec.size() %zu (cleaned).", length, dataVec.size());

      tDiaResult retCode = dia_getProperty(propID,dataVec);
      if ( retCode == DIA_SUCCESS )
      {

         DIA_TR_INF("dia_SrvHandlerGenericIdentRead::vOnProcessRequest - length %zu, dataVec.size() %zu (new data).", length, dataVec.size());

         // Sending back the positive answer
         oDiagMsgBuffer().vSetPosResp();
         oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + dataVec.size()));
         for (size_t i = 0; i < dataVec.size(); ++i)
         {
            (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+i), dataVec[i]);
         }

         vResReadyAndQuit();
      }
      else
      {
         DIA_TR_INF("dia_SrvHandlerGenericIdentRead::vOnProcessRequest UNABLE TO READ ITEM (READ OPERATION FAILED) !!");
         vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      }
   }
   else
   {
      DIA_TR_INF("dia_SrvHandlerGenericIdentRead::vOnProcessRequest UNABLE TO READ ITEM (PROPERTY NOT PASSED AS PARAMETER !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }
}


