/**
 * \file    dia_SrvHandlerGenericIdentADCRead.h
 *
 * \brief   This file contains the definition of the dia_SrvHandlerGenericIdentADCRead class,
 *          that provides a generic service handler that can be used to process
 *          identification requests that require to retrieve a single property from
 *          the ConfigManager.
 *
 * \author
 * \date    2012/04/27
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#ifndef DIA_SRVHANDLERGENERICIDENTADCREAD_H_
#define DIA_SRVHANDLERGENERICIDENTADCREAD_H_

/**
 * \class   dia_SrvHandlerGenericIdentADCRead
 *
 * \brief   Generic service handler to process Identification request
 *
 *          This class provides a generic service handler that can be used to process
 *          identification requests that need to read a single property from
 *          the ConfigManager module.
 *
 * \ingroup diaServicesCommon
 */

class dia_SrvHandlerGenericIdentADCRead
    : public dia_ServiceHandlerUDS
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerGenericIdentADCRead);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericIdentADCRead);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandlerGenericIdentADCRead ( tCString name, tU8 sid, tU8 did );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    */
   dia_SrvHandlerGenericIdentADCRead ( tCString name, tU8 sid, tU16 did );
   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandlerGenericIdentADCRead ( void );
   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  pArname     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    *
    * \return     none
    */
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );
};

#endif /* DIA_SRVHANDLERGENERICIDENTADCREAD_H_ */
