/*
 * dia_SrvHandlerGenericIOCtrlByIdentifier.h
 *
 *  Created on: 19.07.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#define __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include <common/framework/protocols/uds/dia_ServiceHandlerUDS.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL__
#include <common/framework/protocols/uds/ioctrl/dia_IOCtrl.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_IOCONTROL_LISTENER__
#include <common/interfaces/dia_IIOControlListener.h>
#endif

class dia_IOCtrlManager;
class dia_IOCtrlSignal;

//-----------------------------------------------------------------------------

class dia_SrvHandlerGenericIOCtrlByIdentifier
    : public dia_ServiceHandlerUDS,
      public dia_IIOControlListener
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_SrvHandlerGenericIOCtrlByIdentifier);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericIOCtrlByIdentifier);

public:
   //! Receives incoming messages and forward them
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );
   //! called when the component response was not delivered in time
   virtual void vOnTimeout ( void );
   //! retrieve the timeout value for the given ioctrl signal
   virtual tU32 getTimeoutValue ( void ) const;
   //! called to request the lookup keys for this service
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );

   //! there was an update of the given IOCtrlSignal
   virtual void vOnIOCtrlSignalUpdate ( dia_IOCtrlSignal& ioctrl );

   ////////////////////////////////////////////////////////////////////////////
   //
   // deprecated public methods, please don't use and don't refer to the
   // following methods
   //
   ////////////////////////////////////////////////////////////////////////////

   //! this method is deprecated. It forwards the call to IOCtrlManager and is going to be removed in future
   static void vOnSignalUpdate ( dia_IOCtrlSignal* pSignal );

protected:
   //! send positive response depending on the control byte 1
   virtual void vSendIOCtrlPositiveResponse ( dia_IOCtrlSignal& signal, tU8 ctrlState1, tU8 timerValue=0, const std::vector<tU8>* ctrlValue = 0 ); //lint !e1735: checked that default param is equal to base class default param
   //! send negative response
   virtual void vSendIOCtrlNegativeResponse ( tDiaResult errCode );

   //! initialize request processing
   virtual void vInitialize ( void );
   //! finalize request processing
   virtual void vFinalize ( void );

   virtual tDiaResult resetOrInit ( dia_IOCtrlSignal& signal ) const;
   virtual tDiaResult freezeCurrentState ( dia_IOCtrlSignal& signal );
   virtual tDiaResult shortTermAdjustment ( dia_IOCtrlSignal& signal );
   virtual tDiaResult returnControlToECU ( dia_IOCtrlSignal& signal );

protected:
//   //! pointer to the active service handler
//   static dia_SrvHandlerGenericIOCtrlByIdentifier* mpInstance;
   //! pointer to the remote control object
   dia_IOCtrlManager* mpIOCtrlMgr;
   //! type of the signal currently processed by this service handler
   dia_UID mSignalID;
   //! pointer to the signal currently processed by this service handler
   dia_IOCtrlSignal* mpSignal;
   //! control state for the ioctrl, value is either freeze, shortTermAdjustment or returnCtrlToECU
   tU8 mCtrlState;
   //! flag to indicate whether processing is complete
   bool mIsDone;
};

#endif
