/*
 * dia_SrvHandlerGenericControlFaultMemory.cpp
 *
 *  Created on: 03.02.2014
 *      Author: pla2hi
 */
//   TTFis: DIA_REQ UDS 04 19 02 09


// include own class
#include "dia_SrvHandlerGenericControlFaultMemory.h"

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define RS_START                 ((tU8)    3) // The index where data starts in the DiagMsgBufferUds
#define RS_LENGTH_BY_MASK        ((tU8)    1) // The number of bytes in the data part
#define RS_LENGTH_BY_DTC         ((tU8)    4) // The number of bytes in the data part
#define READ_REQ_BUFFER_SIZE     ((tU8)    7) // Maximum read request buffer size
#define DID_POS                  ((tU8)    2) // DID position in the Message buffer

#define DTC_CONTROL_ON           ((tU8)    1) // Set Control On
#define DTC_CONTROL_OFF          ((tU8)    2) // Set Control Off

//------------------------------------------------------------------------------

dia_SrvHandlerGenericControlFaultMemory::dia_SrvHandlerGenericControlFaultMemory ( tU8 u8SubFunction  )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericControlFaultMemory", DIA_C_U8_UDS_SID_CONTROL_DTC_SETTING, u8SubFunction)
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericControlFaultMemory::dia_SrvHandlerGenericControlFaultMemory()");
}

//------------------------------------------------------------------------------
dia_SrvHandlerGenericControlFaultMemory::~dia_SrvHandlerGenericControlFaultMemory ( )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandlerGenericControlFaultMemory::~dia_SrvHandlerGenericControlFaultMemory !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//------------------------------------------------------------------------------

void
dia_SrvHandlerGenericControlFaultMemory::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericControlFaultMemory::vProcessRequest");

   tBool errorDetected = TRUE;
   dia_tenControlType eControlType;

   switch (mDID)
   {
      case DTC_CONTROL_ON:
      {
         DIA_TR_INF("dia_SrvHandlerGenericControlFaultMemory::vProcessRequest => DTC_CONTROL_ON");
         eControlType = DIA_EN_ERRLOG_CONTROL_DTC_SETTING_ON;
         break;
      }
      case DTC_CONTROL_OFF:
      {
         DIA_TR_INF("dia_SrvHandlerGenericControlFaultMemory::vProcessRequest => DTC_CONTROL_OFF");
         eControlType = DIA_EN_ERRLOG_CONTROL_DTC_SETTING_OFF;
         break;
      }
      default:
      {
         // should never happen, define by dia_EngineConfig...
         DIA_TR_ERR("dia_SrvHandlerGenericControlFaultMemory::vProcessRequest => UNKOWN CONTROL id:%x",mDID);
         DIA_ASSERT_ALWAYS();
         vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_SUBFUNCTION_NOT_SUPPORTED_IN_ACTIVE_SESSION));
         return;
      }
   }// switch (u8Control)

   dia_IErrorLog* pInterface = 0;

   if ((querySysAdapterInterface<dia_IErrorLog>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_IErrorLogListener>(this);

      if (pInterface->controlDTCSetting(eControlType) == DIA_SUCCESS)
      {
         errorDetected = FALSE;
      }
      else
      {
         DIA_TR_ERR(" ---  SEND TO SPM SERVER FAILED!!!!");
      }
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }
}

void
dia_SrvHandlerGenericControlFaultMemory::vOnControlResult ( )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericControlFaultMemory::vOnControlResult");
   std::vector<tU8> result;
   result.push_back((tU8)(mDID));

   (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   DIA_TR_INF("dia_SrvHandlerGenericControlFaultMemory::vOnControlResult SUCCESSFUL");
   vSendPositiveResponse(2, &result);
}
