/**
 * \file    dia_SrvHandlerGenericClearFaultMemory.h
 *
 * \brief	This file contains the definition of the dia_SrvHandlerGenericClearFaultMemory class,
 * 			which provides a generic service handler to clear the fault memory.
 *
 * \author  shw2abt
 * \date    2012/06/15
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#ifndef DIA_SRVHANDLERGENERICCLEARFAULTMEMORY_H_
#define DIA_SRVHANDLERGENERICCLEARFAULTMEMORY_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

class dia_SrvHandlerGenericClearFaultMemory
    : public dia_ServiceHandlerUDS,
      public dia_IErrorLogListenerImpl
{
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericClearFaultMemory);

public:
   //! class constructor
   dia_SrvHandlerGenericClearFaultMemory ( void );
   //! class destructor
   virtual ~dia_SrvHandlerGenericClearFaultMemory ( void );

   /**
    * \brief      handle the received request
    *
    *					Function recieves the message via the oDiagMsgBuffer and send it to the SA.
    *					A generic fault memory message function sends the message to the correct
    *					subfunction.
    *
    * \param[in]  void*     -
    * \param[in]  void*     -
    */
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   //! positive response on clearing the fault memory
   virtual void vOnClearResult();
   //! negative response on clearing the fault memory
   virtual void vOnClearError(tU32 u32Error);

protected:
   std::vector<tU8> m_vecGroups;
   tU32 m_u32GroupOfDtc;
};

#endif /* DIA_SRVHANDLERGENERICCLEARFAULTMEMORY_H_ */





