/**
 * \file      dia_SrvHandlerGenericCalibrationItemWrite.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 7, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_CALIBRATION_ITEM_WRITE__
#include "common/services/uds/generic/dia_SrvHandlerGenericCalibrationItemWrite.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

//#ifndef __INCLUDED_DIA_FACTORY_METHODS_PROJECT__
//#include "project/framework/factory/dia_factoryMethodsProject.h"
//#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#define MSG_DATA_OFFSET 4
#define DATA_START      3

using namespace dia;

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericCalibrationItemWrite::dia_SrvHandlerGenericCalibrationItemWrite ( tCString name, tU16 did )
   : dia_ServiceHandlerUDS(name,DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER,did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericCalibrationItemWrite::dia_SrvHandlerGenericCalibrationItemWrite");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericCalibrationItemWrite::~dia_SrvHandlerGenericCalibrationItemWrite ( void )
{}

//----------------------------------------------------------------------

void
dia_SrvHandlerGenericCalibrationItemWrite::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericCalibrationItemWrite::vOnProcessRequest");

   if ( !(vecArgs.size()) )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemWrite: FAILED (Property Not Available) !!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   tU32 propID = VoidCast<tU32>(vecArgs[0]);

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();

   tU8 propData[DIA_PROP_LENGTH_MAX] = {0};
   (void) ::memset(propData,0,DIA_PROP_LENGTH_MAX);

   std::vector<tU8> calibrationData;

   // copy until end of msg. (max ms length == 240B) or '\0' (0x0)
   tU16 len = 0;
   for ( ; len < (oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET); len++ )
   {
      propData[len] = pU8[len+MSG_DATA_OFFSET];
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemWrite::calibrationData[%d] 0x%02x", len, propData[len]);
      calibrationData.push_back(propData[len]);
   }

   tDiaResult retCode = validateData(calibrationData);

   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemWrite: FAILED (DATA VALIDATION) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
      return;
   }

   retCode = preProcess(calibrationData);

   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemWrite: FAILED (PREPROCESSING) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
      return;
   }

   if ( dia_setProperty(propID,calibrationData) != DIA_SUCCESS )
   {
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemWrite: CALIBRATION REJECTED --> KDS WRITE FAILED !!!");
      vSendNegativeResponse(DIA_E_U8_UDS_GENERAL_PROGRAMMING_FAILURE);
      return;
   }

   retCode = postProcess(calibrationData);

   switch ( retCode )
   {
   case DIA_SUCCESS:
      // Sending back the positive answer
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemWrite: SUCCEEDED");
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START);
      vResReadyAndQuit();
      break;

   default:
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemWrite: Send negative response");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
      break;
   }
}

//----------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericCalibrationItemWrite::preProcess ( const std::vector<tU8>& /*data*/ )
{
   return DIA_SUCCESS;
}

//----------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericCalibrationItemWrite::postProcess ( const std::vector<tU8>& /*data*/ )
{
   return DIA_SUCCESS;
}

//----------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericCalibrationItemWrite::validateData ( const std::vector<tU8>& /*data*/ )
{
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericCalibrationItemWrite::checkLength ( tU32 length, tU32 minValue, tU32 maxValue )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericCalibrationItemWrite::checkLength");
   return ((length >= minValue) && (length <= maxValue)) ? DIA_SUCCESS : DIA_FAILED;
}
