/**
 * \file      dia_SrvHandlerGenericCalibrationItemRead.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 7, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#include "dia_SrvHandlerGenericCalibrationItemRead.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#define DATA_START (1/*sizeof(SID)*/ + mDIDLen)
using namespace dia;
//-----------------------------------------------------------------------------

dia_SrvHandlerGenericCalibrationItemRead::dia_SrvHandlerGenericCalibrationItemRead ( tCString name, tU16 did )
   : dia_ServiceHandlerUDS(name,DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericCalibrationItemRead::dia_SrvHandlerGenericCalibrationItemRead(tCString,tU8,tU16)");
   mDefaultData.clear();
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericCalibrationItemRead::dia_SrvHandlerGenericCalibrationItemRead ( tCString name, tU16 did, const std::vector<tU8>& defaultData )
   : dia_ServiceHandlerUDS(name,DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) did),
     mDefaultData(defaultData)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericCalibrationItemRead::dia_SrvHandlerGenericCalibrationItemRead(tCString,tU8,tU16,vector<tU8>)");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericCalibrationItemRead::dia_SrvHandlerGenericCalibrationItemRead ( tCString name, tU16 did, const tU8 defaultData[], tU16 dataLength )
   : dia_ServiceHandlerUDS(name,DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericCalibrationItemRead::dia_SrvHandlerGenericCalibrationItemRead(tCString,tU8,tU16,tU8[],tU16)");
   mDefaultData.clear();
   for ( tU16 i=0; i<dataLength; i++ ) mDefaultData.push_back(defaultData[i]);
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericCalibrationItemRead::~dia_SrvHandlerGenericCalibrationItemRead ( void )
{}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerGenericCalibrationItemRead::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericCalibrationItemRead::vOnProcessRequest");

   tU32 retCode = DIA_FAILED;

   if ( vecArgs.size() )
   {
      tU32 propID = VoidCast<tU32>(vecArgs[0]);

      // data memory
      tU8 u8propData[DIA_PROP_LENGTH_MAX] = {0};
      // initialize the data memory
      (void) ::memset(u8propData,0,DIA_PROP_LENGTH_MAX);

      // retrieve size of property
      auto u16datalength = dia_getPropertySize(propID); //DIA_PROP_LENGTH_MAX;
      retCode = dia_getProperty(propID,u8propData,u16datalength);

      if ( retCode != DIA_SUCCESS )
      {
         if ( mDefaultData.size() )
         {
            //data = mDefaultData;
            for (tU16 i = 0; i < mDefaultData.size(); ++i) 
            {
               u8propData[i] = mDefaultData[i];
            }
         }
         else
         {
            DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemRead::ReadDataByIdentifier FAIL <--------------");
            DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemRead::ReadDataByIdentifier Unable to read Item.");
            // Sending back the Negative answer
            vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
            return;
         }
         // Sending back the positive answer
         oDiagMsgBuffer().vSetPosResp();
         oDiagMsgBuffer().vSetDataLength((tU16)(DATA_START + mDefaultData.size()));

         for (tU16 i = 0; i < mDefaultData.size(); ++i) 
         {
            (void) oDiagMsgBuffer().vSetDataU8((tU16)(DATA_START+i), u8propData[i]);
         }
         DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemRead::ReadDataByIdentifier SUCCESSFUL");
         vResReadyAndQuit();
      }
      else
      {
         // Sending back the positive answer
         oDiagMsgBuffer().vSetPosResp();
         /*oDiagMsgBuffer().vSetDataLength(DATA_START+data.size());*/
         oDiagMsgBuffer().vSetDataLength((tU16)(DATA_START + u16datalength));

         for (tU16 i = 0; i < u16datalength; ++i) 
         {
            (void) oDiagMsgBuffer().vSetDataU8((tU16)(DATA_START+i), u8propData[i]);
         }
         DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemRead::ReadDataByIdentifier SUCCESSFUL");
         vResReadyAndQuit();
      }
   }
   else
   {
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemRead::ReadDataByIdentifier FAIL ()<--------------");
      DIA_TR_INF("dia_SrvHandlerGenericCalibrationItemRead::ReadDataByIdentifier NO PARAMETER.");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
