/*
 * dia_SrvHandlerGenericBTNameWrite.cpp
 *
 *  Created on: 02.07.2015
 *      Author: nbs3kor
 *      --------------------------------------------------------------------------------------
 *      Date        Author       Modification
 *
 *		28.07.2017   mky6kor    Solved Target Reset issue while writing 29 bytes of data or more (NCG3D-53062).
 *      ---------------------------------------------------------------------------------------
 */
#ifndef DIA_SRVHANDLER_GENERICBTNAMEWRITE_H_
#include "dia_SrvHandlerGenericBTNameWrite.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define DATA_START        (tU16)3
using namespace dia;
//-----------------------------------------------------------------------------

dia_SrvHandlerGenericBTNameWrite::dia_SrvHandlerGenericBTNameWrite (tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name, sid, did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericBTNameWrite::dia_SrvHandlerGenericBTNameWrite(tCString name, tU8 sid, tU16 did)");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericBTNameWrite::~dia_SrvHandlerGenericBTNameWrite( void )
{
}

//-------------------------------------------------------------------------------

tVoid
dia_SrvHandlerGenericBTNameWrite::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericBTNameWrite::vOnProcessRequest");

   /* SrvHandler Defines according to CDD-File */
   #define MSG_DATA_OFFSET 4                        // Offset from oDiagMsgBuffer-start to 1st data-byte (e.g. MemorySize-Byte)
   /*------------------------------------------*/

   DIA_TR_INF("Recieved data buffer length %d !!", oDiagMsgBuffer().u16GetDataLength());


   if ( !(vecArgs.size()) && (2 == (vecArgs.size())))
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericBTNameWrite: FAILED (Property Not Available) !!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   tU32 propID = VoidCast<tU32>(vecArgs[0]);
   tU32 BTName_length = VoidCast<tU32>(vecArgs[1]);

   // Check length of BT name
   if ( 
      (oDiagMsgBuffer().u16GetDataLength() <= MSG_DATA_OFFSET) 
      || 
      static_cast<tU32>(oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET) != (BTName_length)
      )
   {
      DIA_TR_INF("dia_SrvHandlerGenericBTNameWrite: BT name length=%d is different than (%d).", (oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET), BTName_length);
      DIA_TR_ERR(" ### dia_SrvHandlerGenericBTNameWrite: FAILED (DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT) !!");
      vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
      return;
   }

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
   std::vector<tU8> BTName(BTName_length, 0);

   tU16 u16EleCount = 0;
   //BT Name
   for ( ; (u16EleCount < (oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET)); u16EleCount++)
   {
     if ( u16EleCount < DIA_PROP_LENGTH_MAX )
     {
    	 BTName[u16EleCount] = pU8[u16EleCount+MSG_DATA_OFFSET];
        DIA_TR_INF("dia_SrvHandlerGenericBTNameWrite::u8propData[%d] 0x%02x", u16EleCount, BTName[u16EleCount]);
     }
   }

   tDiaResult retCode = validateData(&BTName[0], u16EleCount);

   if ( retCode != DIA_SUCCESS )
   {
     // Sending back the Negative answer
     DIA_TR_INF("dia_SrvHandlerGenericBTNameWrite: FAILED (DATA VALIDATION) !!");
     vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
     return;
   }

   retCode = dia_setProperty ( propID, &BTName[0], u16EleCount );

   if ( retCode != DIA_SUCCESS )
   {
     // Sending back the Negative answer
     DIA_TR_INF("dia_SrvHandlerGenericBTNameWrite: FAILED (WRITE DATA TO PERSISTENT MEMORY) !!");
     vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
     return;
   }


   // Sending back the positive answer
   DIA_TR_INF("dia_SrvHandlerGenericBTNameWrite: SUCCEEDED");
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START);
   vResReadyAndQuit();
}



