/**
 * \file      dia_RoutineCtrlGetProcStatByProcessname.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    fan4hi
 * \date      Jan 29, 2018
 *
 * \copyright Robert Bosch Car Multimedia 2018
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GET_PROC_STAT_BY_PROCESSNAME_H_
#include "common/services/uds/generic/dia_RoutineCtrlGetProcStatByProcessname.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_PROC_INFO_H_
#include "common/framework/utils/dia_ProcInfo.h"
#endif

namespace dia
{

RoutineCtrlGetProcStatByProcessname::RoutineCtrlGetProcStatByProcessname(tCString name, tU16 udsID, dia_eRoutineID routineID)
   : dia_Routine(name, udsID, routineID, DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);
}

//------------------------------------------------------------------------------

RoutineCtrlGetProcStatByProcessname::~RoutineCtrlGetProcStatByProcessname()
{
}

//------------------------------------------------------------------------------

tDiaResult RoutineCtrlGetProcStatByProcessname::start(std::vector<tU8>& params, tU8 /*timerValue*/)
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   ProcInfo                   procinfo;
   int                        i, pid=-1;
   std::vector<tU8>::iterator iter;
   bool                       success=false;
   char                       procname[PROCINFO_PROC_NAME_MAX+1];
   static const char          format[]=
   {
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_UNSIGNED,   4),   // pid
      PROCINFOFORMAT_SKIPNAME,
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_CHARACTER,  1),   // state
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // ppid
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // pgrp
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // session
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // tty_nr
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // tpgid
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_HEXDUMP,    4),   // flags
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_UNSIGNED,   4),   // minflt
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_UNSIGNED,   4),   // cminflt
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_UNSIGNED,   4),   // majflt
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_UNSIGNED,   4),   // cmajflt
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_TIME,       8),   // utime
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_TIME,       8),   // stime
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_TIME,       8),   // cutime
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_TIME,       8),   // cstime
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // priority
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // nice
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // num_threads
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // itrealvalue
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_TIME,       8),   // starttime
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_KBYTES,     4),   // vsize
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_PAGES,      4),   // rss
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_KBYTES,     4),   // rsslim
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_HEXDUMP,    8),   // startcode
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_HEXDUMP,    8),   // endcode
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_HEXDUMP,    8),   // startstack
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_HEXDUMP,    8),   // kstkesp
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_HEXDUMP,    8),   // kstkeip
      PROCINFOFORMAT_SKIP, // signal
      PROCINFOFORMAT_SKIP, // blocked
      PROCINFOFORMAT_SKIP, // sisignore
      PROCINFOFORMAT_SKIP, // sigcatch
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_HEXDUMP,    8),   // wchan
      PROCINFOFORMAT_SKIP, // nswap
      PROCINFOFORMAT_SKIP, // cnswap
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // exit_signal
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_SIGNED,     4),   // processor
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_UNSIGNED,   4),   // rt_priority
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_UNSIGNED,   4),   // policy
      PROCINFOFORMAT_SKIP, // delayacct_blkio_ticks
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_TIME,       8),   // guest_time
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_TIME,       8),   // cguest_time
      PROCINFOFORMAT_END_SEQUENCE,
   };

   if(params.size()>PROCINFO_PROC_NAME_MAX)
      return DIA_FAILED; // CHECKME: Is this the correct error code? Is there anything else to do?
   else
   {
      for(i=0, iter=params.begin(); iter!=params.end(); i++, ++iter)
         procname[i]=*iter;
      procname[i]=0;

      if(!procname[0])
         return DIA_FAILED; // CHECKME: Is this the correct error code? Is there anything else to do?
      else
      {
         // NOTE: There might be multiple instances of a process. For now, we check just the first one.
         if((pid=procinfo.GetPID(procname))>=0)
         {
            mResults.clear();
            if(procinfo.ParseStatValues(mResults, pid, format))
               success=true;
         }
      }
   }

   // Variable for Service Handler Framework that this job is done //! indicate that we are done
   mIsResultReady=TRUE;

   if(success==true)
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   else
      return DIA_FAILED; // CHECKME: Is this the correct error code? Is there anything else to do?

   return DIA_SUCCESS;
}

tDiaResult RoutineCtrlGetProcStatByProcessname::requestResult(std::vector<tU8>& results)
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());
   results.insert(results.end(), mResults.begin(), mResults.end());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void RoutineCtrlGetProcStatByProcessname::vOnServiceTimeout(void)
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   eSetStatus(DIA_EN_RTCTRL_STATUS_TIMED_OUT);

#ifndef __DIA_UNIT_TESTING__
   dia_RoutineCtrlManager* pRTCtrlMgr=getInstanceOfRoutineControlManager();

   if(pRTCtrlMgr)
   {
       pRTCtrlMgr->vOnRoutineUpdate(*this);
   }
#endif
}

} // namespace dia
