/*
 * dia_RoutineCtrlGenericSecuritySettingsSCC.h
 *
 *  Created on: 17.03.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_SECURITY_SETTINGS_SCC__
#define __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_SECURITY_SETTINGS_SCC__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EXECUTE_SYSTEM_COMMAND__
#include <common/services/uds/generic/dia_RoutineCtrlExecuteSystemCommand.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINECTRLSCCSECURITYSETTINGSFSM__
#include <common/framework/fsm/generated/dia_RoutineCtrlSCCSecuritySettingsFSM.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

namespace dia
{

class RoutineCtrlGenericSecuritySettingsSCC
   : public RoutineCtrlExecuteSystemCommand,
     protected dia_RoutineCtrlSCCSecuritySettingsFSM::FsmBehaviour,
     public dia_ISpmListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlGenericSecuritySettingsSCC);

public:
   RoutineCtrlGenericSecuritySettingsSCC ( tCString name, tU16 udsID, const std::string& cmdName );
   RoutineCtrlGenericSecuritySettingsSCC ( const std::string& name, tU16 udsID, const std::string& cmdName );
   virtual ~RoutineCtrlGenericSecuritySettingsSCC ( void );

   virtual void vOnServiceTimeout ( void );

   void setReconnectTimeout ( tU16 timeout ) { mReconnectTimeout = timeout; }
   void setReconnectCycleTime ( tU16 cycleTime ) { mReconnectCycleTime = cycleTime; }
   void setReconnectRetries ( tU16 retries ) { mReconnectRetries = retries; }

   void setRequestedSystemState ( dia_eSpmSystemState state ) { mSystemStateRequested = state; }
   void setRequestedSystemSubState ( dia_eSpmSubState substate ) { mSystemSubStateRequested = substate; }

   //! notification about a system state status
   virtual void vOnSystemState ( dia_eSpmSystemState state, dia_eSpmSystemState prevState );
   //! Response for sendOnOffTrigger request
   virtual void vOnAckOnOffTrigger ( tDiaResult response );

   virtual tDiaResult requestResult ( std::vector<tU8>& results );

protected:
   //! deprecated constructor without implementation
   RoutineCtrlGenericSecuritySettingsSCC ( void );

   //! setup (create objects,...)
   virtual tDiaResult setup ( void );
   //! tear down (destroy objects,...)
   //lint -sem(dia::RoutineCtrlGenericSecuritySettingsSCC::tearDown,cleanup)
   virtual tDiaResult tearDown ( void );

   tDiaResult acceptEvent ( dia_RoutineCtrlSCCSecuritySettingsFSM::FsmEvent event, void* pArg );

   virtual void executeStartSystemCommand ( void );
   virtual void onSystemCommandStarted ( void );
   virtual void onSystemCommandStartupFailed ( void );

   // FSM actions
   virtual void vFsmCollectResults ( void* pArg );
   virtual void vFsmEvaluateResults ( void* pArg );
   virtual void vFsmFinalizeSystemStateSetting ( void* pArg );
   virtual void vFsmGetSystemState ( void* pArg );
   virtual void vFsmRequestSystemState ( void* pArg );
   virtual void vFsmReset ( void* pArg );
   virtual void vFsmSendResponse ( void* pArg );
   virtual void vFsmSetError_AppStartFailed ( void* pArg );
   virtual void vFsmSetError_Timeout ( void* pArg );
   virtual void vFsmSetResultRunning ( void* pArg );
   virtual void vFsmSetResultsInProgress ( void* pArg );
   virtual void vFsmSetResultsNotAvailable ( void* pArg );
   virtual void vFsmStartReconnection ( void* pArg );
   virtual void vFsmStartUpdateApplication ( void* pArg );

   // FSM guards
   virtual bool bFsmIsRequiredSystemState ( void* pArg );
   virtual bool bFsmIsRunning ( void* pArg );
   virtual bool bFsmNeedToRequestSystemState ( void* pArg );


protected:
   //! pointer to the state machine
   dia_RoutineCtrlSCCSecuritySettingsFSM::Fsm* mpFSM; //lint -sem(dia::dia_SCCManager::tearDown, cleanup)
   bool mIsRequiredSystemStateActive;
   bool mNeedToRequestSystemState;
   std::vector<std::string> mSystemCommandArgs;

   tU16 mReconnectTimeout;
   tU16 mReconnectCycleTime;
   tU16 mReconnectRetries;

   dia_eSpmSystemState mSystemStateRequested;
   dia_eSpmSubState    mSystemSubStateRequested;
   dia_eSpmSystemState mSystemStateActive;
   bool mWasRoutineStarted;
};

}

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_SECURITY_SETTINGS_SCC__ */

