/*
 * dia_RoutineCtrlSecuritySettingsSCC.cpp
 *
 *  Created on: 17.03.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_SECURITY_SETTINGS_SCC__
#include <common/services/uds/generic/dia_RoutineCtrlGenericSecuritySettingsSCC.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM__
#include "common/interfaces/dia_ISpm.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SCC_MANAGER__
#include <common/framework/application/dia_SCCManager.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include <common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include <common/framework/utils/dia_utilities.h>
#endif

#include <errno.h>    //lint !e451 !e537 repeatedly included header file without standard include guard
#include <unistd.h>   //lint !e451 !e537 repeatedly included header file without standard include guard
#include <sys/wait.h> //lint !e451 !e537 repeatedly included header file without standard include guard

#define DIA_C_U16_DEFAULT_RECONNECTION_TIMEOUT     ((tU16) 5000)
#define DIA_C_U16_DEFAULT_RECONNECTION_CYCLETIME   ((tU16) 1000)
#define DIA_C_U16_DEFAULT_RECONNECTION_RETRIES     ((tU16)   20)

static tCString arSystemStateMapping[] = {
   "DIA_EN_SPM_SYSTEM_STATE_UNKNOWN",
   "DIA_EN_SPM_SYSTEM_STATE_SUSPEND",
   "DIA_EN_SPM_SYSTEM_STATE_STANDBY",
   "DIA_EN_SPM_SYSTEM_STATE_OFF",
   "DIA_EN_SPM_SYSTEM_STATE_DOWNLOAD",
   "DIA_EN_SPM_SYSTEM_STATE_ON",
   "DIA_EN_SPM_SYSTEM_STATE_BACKGROUND",
   "DIA_EN_SPM_SYSTEM_STATE_DOOR_OPEN",
   "DIA_EN_SPM_SYSTEM_STATE_IGNITION",
   "DIA_EN_SPM_SYSTEM_STATE_DIAGNOSIS",
   "DIA_EN_SPM_SYSTEM_STATE_PROFILE",
   "DIA_EN_SPM_SYSTEM_STATE_PREPARE_SHUTDOWN",
   "DIA_EN_SPM_SYSTEM_STATE_SHUTDOWN",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE_1",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE_2",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_ON",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_RESTRICTED",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_ON_DIAG",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_ON_TEL",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_ON_SWDL",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_CUSTOMER_SWDL",
   "DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE",
   "DIA_EN_SPM_SYSTEM_STATE_OVERTEMP",
   "DIA_EN_SPM_SYSTEM_STATE_SAFE",
   "DIA_EN_SPM_SYSTEM_STATE_STATE_MAX",
   "DIA_EN_SPM_SYSTEM_STATE_COUNT"
};

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

RoutineCtrlGenericSecuritySettingsSCC::RoutineCtrlGenericSecuritySettingsSCC ( tCString name, tU16 udsID, const std::string& cmdName )
   : RoutineCtrlExecuteSystemCommand(name,udsID,cmdName, DIA_EN_RTCTRL_TYPE_LONG_TERM),
     mpFSM(0),
     mIsRequiredSystemStateActive(false),
     mNeedToRequestSystemState(true),
     mReconnectTimeout(DIA_C_U16_DEFAULT_RECONNECTION_TIMEOUT),
     mReconnectCycleTime(DIA_C_U16_DEFAULT_RECONNECTION_CYCLETIME),
     mReconnectRetries(DIA_C_U16_DEFAULT_RECONNECTION_RETRIES),
     mSystemStateRequested(DIA_EN_SPM_SYSTEM_STATE_DIAGNOSIS),
     mSystemSubStateRequested(DIA_EN_SPM_SUBSTATE_DIAGNOSIS_REQUEST),
     mSystemStateActive(DIA_EN_SPM_SYSTEM_STATE_UNKNOWN),
     mWasRoutineStarted(false)
{
   dia_tclFnctTrace oTrace("dia::RoutineCtrlGenericSecuritySettingsSCC::RoutineCtrlGenericSecuritySettingsSCC");
   (void) RoutineCtrlGenericSecuritySettingsSCC::setup();
}

//---------------------------------------------------------------------------------------------------------------------

RoutineCtrlGenericSecuritySettingsSCC::RoutineCtrlGenericSecuritySettingsSCC ( const std::string& name, tU16 udsID, const std::string& cmdName )
   : RoutineCtrlExecuteSystemCommand(name,udsID,cmdName, DIA_EN_RTCTRL_TYPE_LONG_TERM),
     mpFSM(0),
     mIsRequiredSystemStateActive(false),
     mNeedToRequestSystemState(true),
     mReconnectTimeout(DIA_C_U16_DEFAULT_RECONNECTION_TIMEOUT),
     mReconnectCycleTime(DIA_C_U16_DEFAULT_RECONNECTION_CYCLETIME),
     mReconnectRetries(DIA_C_U16_DEFAULT_RECONNECTION_RETRIES),
     mSystemStateRequested(DIA_EN_SPM_SYSTEM_STATE_DIAGNOSIS),
     mSystemSubStateRequested(DIA_EN_SPM_SUBSTATE_DIAGNOSIS_REQUEST),
     mSystemStateActive(DIA_EN_SPM_SYSTEM_STATE_UNKNOWN),
     mWasRoutineStarted(false)
{
   dia_tclFnctTrace oTrace("dia::RoutineCtrlGenericSecuritySettingsSCC::RoutineCtrlGenericSecuritySettingsSCC");
   (void) RoutineCtrlGenericSecuritySettingsSCC::setup();
}

//---------------------------------------------------------------------------------------------------------------------

RoutineCtrlGenericSecuritySettingsSCC::~RoutineCtrlGenericSecuritySettingsSCC ( void )
{
   _BP_TRY_BEGIN
   {
      (void) RoutineCtrlGenericSecuritySettingsSCC::tearDown();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("dia::RoutineCtrlGenericSecuritySettingsSCC::~RoutineCtrlGenericSecuritySettingsSCC - Exception caught!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
RoutineCtrlGenericSecuritySettingsSCC::setup ( void )
{
   dia_tclFnctTrace trc("RoutineCtrlGenericSecuritySettingsSCC::setup");

   if ( !mpFSM )
   {
      // create the state machine object
      if ( !(dia_RoutineCtrlSCCSecuritySettingsFSM::Fsm::createFSM(&mpFSM,this)) )
      {
         DIA_TR_INF( "### STATE MACHINE INITIALIZATION FAILED ###");
         return DIA_FAILED;
      }
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
RoutineCtrlGenericSecuritySettingsSCC::tearDown ( void )
{
   if ( mpFSM )
   {
      OSAL_DELETE mpFSM;
      mpFSM = 0;
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vOnServiceTimeout()");

   (void) acceptEvent(dia_RoutineCtrlSCCSecuritySettingsFSM::evTimeout,0);
}

//-----------------------------------------------------------------------------

tDiaResult
RoutineCtrlGenericSecuritySettingsSCC::acceptEvent ( dia_RoutineCtrlSCCSecuritySettingsFSM::FsmEvent event, void* pArg )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::acceptEvent(dia_RoutineCtrlSCCSecuritySettingsFSM::FsmEvent,void*)");

   if ( !mpFSM )  return DIA_E_FSM_NOT_AVAILABLE;

   mErrorCode = DIA_E_NO_ERROR;

   DIA_TR_INF("RoutineCtrlGenericSecuritySettingsSCC::acceptEvent - State (before): %s (Event = %s)", mpFSM->getStateName(), dia_RoutineCtrlSCCSecuritySettingsFSM::getEventName(event));
   mpFSM->acceptEvent(event,pArg);
   DIA_TR_INF("RoutineCtrlGenericSecuritySettingsSCC::acceptEvent - State (after) : %s", mpFSM->getStateName());

   return mErrorCode;
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmCollectResults ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmCollectResults(void*)");
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmEvaluateResults ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmEvaluateResults(void*)");
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmFinalizeSystemStateSetting ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmFinalizeSystemStateSetting(void*)");
   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmGetSystemState ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmGetSystemState(void*)");

   dia_ISpm* pInterface = 0;
   tDiaResult retCode = querySysAdapterInterface<dia_ISpm>(&pInterface);
   if ( (retCode == DIA_SUCCESS) && pInterface )
   {
      (void) pInterface->getSystemState(mSystemStateActive);
      DIA_TR_INF("SYSTEMSTATE (ACTIVE)    = 0x%08x",mSystemStateActive);
      DIA_TR_INF("SYSTEMSTATE (REQUESTED) = 0x%08x",mSystemStateRequested);

      if ( mSystemStateActive == mSystemStateRequested )
      {
         DIA_TR_INF("NO NEED TO REQUEST SYSTEMSTATE !!");
         mNeedToRequestSystemState = false;
         mIsRequiredSystemStateActive = true;
      }

      // we are already in the requested system state
      (void) acceptEvent(dia_RoutineCtrlSCCSecuritySettingsFSM::evSystemStateUpdate,0);
   }
   else
   {
      // tbd: trigger error event
   }
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmRequestSystemState ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmRequestSystemState(void*)");

   dia_ISpm* pInterface = 0;
   tDiaResult retCode = querySysAdapterInterface<dia_ISpm>(&pInterface);
   if ( (retCode == DIA_SUCCESS) && pInterface )
   {
      (void) setSysAdapterListener<dia_ISpmListener>(this);
      (void) pInterface->sendOnOffTrigger(mSystemSubStateRequested,TRUE);
      DIA_TR_INF("REQUESTED SYSTEM SUBSTATE = 0x%08x",mSystemSubStateRequested);
   }
   else
   {
      // tbd: trigger error event
   }
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmReset ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmReset(void*)");
   mIsRequiredSystemStateActive = false;
   mNeedToRequestSystemState = true;
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmSendResponse ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmSendResponse(void*)");

   DIA_TR_INF("vFsmSendResponse: mErrorCode = 0x%08x",mErrorCode);

   if ( mErrorCode != DIA_E_NO_ERROR )
   {
      mIsResultReady = TRUE;
      getInstanceOfRoutineControlManager()->vOnRoutineUpdate(*this);
   }
   else
   {
      DIA_TR_INF("vFsmSendResponse: mIsResultReady = %s",((mIsResultReady == TRUE) ? "TRUE" : "FALSE"));
      DIA_TR_INF("vFsmSendResponse: mIsRequiredSystemStateActive = %s",((mIsRequiredSystemStateActive) ? "TRUE" : "FALSE"));
      DIA_TR_INF("vFsmSendResponse: mNeedToRequestSystemState = %s",((mNeedToRequestSystemState) ? "TRUE" : "FALSE"));

      // fill response here, will be ignored by requestResult, which is called directy after this by framework
      if ( mIsResultReady == TRUE )
      {
         if ( /*!(mIsRequiredSystemStateActive && (!*/ mNeedToRequestSystemState /*))*/ )
         {
//            mResults.push_back(mResponseStatus);
            getInstanceOfRoutineControlManager()->vOnRoutineUpdate(*this);
         }
         else
         {
            // TBD
         }
      }
   }
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmSetError_AppStartFailed ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmSetError_AppStartFailed(void*)");
   mErrorCode = DIA_E_ROUTINE_START_FAILED;
   mWasRoutineStarted = false;
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmSetError_Timeout ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmSetError_Timeout(void*)");
   mErrorCode = DIA_E_ROUTINE_TIMEOUT;
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmSetResultRunning ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmSetResultRunning(void*)");
   mResponseStatus = ROUTINE_RUNNING;
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmSetResultsInProgress ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmSetResultsInProgress(void*)");
   mResponseStatus = ROUTINE_RUNNING;
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmSetResultsNotAvailable ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmSetResultsNotAvailable(void*)");
   mResponseStatus = ROUTINE_NOK;
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmStartReconnection ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmStartReconnection(void*)");

   // trigger reconnection to the INC channel
   getInstanceOfSCCManager()->onSccReconnect(mReconnectTimeout,mReconnectCycleTime,mReconnectRetries);
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vFsmStartUpdateApplication ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vFsmStartUpdateApplication(void*)");
   mWasRoutineStarted = true;
   startSystemCommand();
}

//-----------------------------------------------------------------------------

bool
RoutineCtrlGenericSecuritySettingsSCC::bFsmIsRequiredSystemState ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::bFsmIsRequiredSystemState(void*)");
   return mIsRequiredSystemStateActive;
}

//-----------------------------------------------------------------------------

bool
RoutineCtrlGenericSecuritySettingsSCC::bFsmIsRunning ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::bFsmIsRunning(void*)");
   return mIsRunning;
}

//-----------------------------------------------------------------------------

bool
RoutineCtrlGenericSecuritySettingsSCC::bFsmNeedToRequestSystemState ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::bFsmNeedToRequestSystemState(void*)");
   return mNeedToRequestSystemState;
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vOnSystemState ( dia_eSpmSystemState state, dia_eSpmSystemState prevState )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vOnSystemState(dia_eSpmSystemState,dia_eSpmSystemState)");

   DIA_TR_INF("New State = \"%s\", Last State = \"%s\"", arSystemStateMapping[state],arSystemStateMapping[prevState]);

   mSystemStateActive = state;

   if ( mSystemStateActive == mSystemStateRequested )
   {
//    mNeedToRequestSystemState = false;
      mIsRequiredSystemStateActive = true;

      // we are already in the requested system state
      (void) acceptEvent(dia_RoutineCtrlSCCSecuritySettingsFSM::evSystemStateUpdate,0);
   }
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::vOnAckOnOffTrigger ( tDiaResult response )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::vOnAckOnOffTrigger(tDiaResult)");
//   mNeedToRequestSystemState = false;
   DIA_TR_INF("Result of vOnAckOnOffTrigger: %s", ((response == DIA_SUCCESS) ? "DIA_SUCCESS" : "DIA_FAILED"));
}

//-----------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::executeStartSystemCommand ( void )
{
   dia_tclFnctTrace oTrace("RoutineCtrlGenericSecuritySettingsSCC::executeStartSystemCommand()");
   (void) acceptEvent( dia_RoutineCtrlSCCSecuritySettingsFSM::evStart,0);
}

//---------------------------------------------------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::onSystemCommandStarted ( void )
{
   dia_tclFnctTrace oTrace("dia::RoutineCtrlGenericSecuritySettingsSCC::onSystemCommandStarted()");

   (void) acceptEvent(dia_RoutineCtrlSCCSecuritySettingsFSM::evUpdateApplicationStarted,0);
}

//---------------------------------------------------------------------------------------------------------------------

void
RoutineCtrlGenericSecuritySettingsSCC::onSystemCommandStartupFailed ( void )
{
   dia_tclFnctTrace oTrace("dia::RoutineCtrlGenericSecuritySettingsSCC::onSystemCommandStartupFailed()");
   (void) acceptEvent(dia_RoutineCtrlSCCSecuritySettingsFSM::evUpdateApplicationNotStarted,0);
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlGenericSecuritySettingsSCC::requestResult ( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("dia::RoutineCtrlGenericSecuritySettingsSCC::requestResult");

   DIA_TR_INF("mErrorCode = 0x%08x",mErrorCode);

   if ( mErrorCode == DIA_SUCCESS )
   {
      if ( !mWasRoutineStarted )
      {
         mErrorCode = DIA_E_SEQUENCE_ERROR;
      }
   }

   tDiaResult retCode = RoutineCtrlExecuteSystemCommand::requestResult(results);
   mErrorCode = DIA_SUCCESS;

   return retCode;
}

}

