/*
 * dia_RoutineCtrlGenericCalculateConfigFingerprint.cpp
 *
 *  Created on: 18.06.2015
 *      Author: bhs1hi
 */

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

// include own class
#include "dia_RoutineCtrlGenericCalculateConfigFingerprint.h"

namespace dia
{

//------------------------------------------------------------------------------

RoutineCtrlGenericCalculateConfigFingerprint::RoutineCtrlGenericCalculateConfigFingerprint (tCString name, tU16 udsID)
   : dia_Routine(name, udsID, DIA_EN_RTCTRL_TYPE_SHORT_TERM),
     mDID (udsID)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenericCalculateConfigFingerprint::dia_RoutineCtrlGenericCalculateConfigFingerprint()");
}

//------------------------------------------------------------------------------

RoutineCtrlGenericCalculateConfigFingerprint::RoutineCtrlGenericCalculateConfigFingerprint (tCString name, tU16 udsID, const dia_FingerprintInfo fingerprintData[], const tU16 numOfInfo)
   : dia_Routine (name, udsID, DIA_EN_RTCTRL_TYPE_SHORT_TERM),
     mDID (udsID)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenericCalculateConfigFingerprint::dia_RoutineCtrlGenericCalculateConfigFingerprint()");

   if (( fingerprintData ) && ( numOfInfo > 0 ))
   {
      for ( tU16 i=0; i<numOfInfo; i++ )
      {
         mFingerprintInfoRep.push_back(fingerprintData[i]);
      }
   }
}

//------------------------------------------------------------------------------

RoutineCtrlGenericCalculateConfigFingerprint::~RoutineCtrlGenericCalculateConfigFingerprint ( void )
{
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlGenericCalculateConfigFingerprint::start ( std::vector<tU8>& /*params*/, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenericCalculateConfigFingerprint::start()");

   tDiaResult retCode = DIA_FAILED;

   std::vector<tU8> data;

   // prepare processing of the routine
   vInitialize();

   eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);

   tU16 u16InfoSize = static_cast<tU16>(mFingerprintInfoRep.size());

   if ( u16InfoSize == 0 )
   {
      return retCode;
   }

   size_t configDataLen;

   for ( tU16 i = 0; i < u16InfoSize; i++ )
   {
      configDataLen = dia_getPropertySize(mFingerprintInfoRep[i].mProperty);
      std::vector<tU8> configData(configDataLen, 0);

      // read the data without the CRC value at the end
      if ( DIA_SUCCESS != dia_getProperty(mFingerprintInfoRep[i].mProperty, configData) )
      {
         DIA_TR_ERR("dia_RoutineCtrlGenericCalculateConfigFingerprint::start Reading configuration item 0x%0x has failed !!", mFingerprintInfoRep[i].mProperty);
      }
      else
      {
         // reading was successful so append the data to the configuration data vector
         data.insert(data.end(), configData.begin(), configData.end() - mFingerprintInfoRep[i].mCrcLen);
      }
   }

   if ( !data.empty() )
   {
     if(true == dia_nsUtilities::generateHash(data, mResults)) //Coverity Fix(CID:52365)
     {
       DIA_TR_INF("dia_RoutineCtrlGenericCalculateConfigFingerprint:: generateHash Successful");
       eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
       retCode = DIA_SUCCESS;
     }
     else
     {
       DIA_TR_INF("dia_RoutineCtrlGenericCalculateConfigFingerprint:: generateHash Failed");
       retCode = DIA_FAILED;
     }
     mIsResultReady = TRUE;
   }
   else
   {
      DIA_TR_ERR("dia_RoutineCtrlGenericCalculateConfigFingerprint::start Hash can not be calculated --- All reading configuration FAILED !!");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlGenericCalculateConfigFingerprint::requestResult ( std::vector<tU8>& results )
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());
   results.insert(results.end(), mResults.begin(), mResults.end());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void
RoutineCtrlGenericCalculateConfigFingerprint::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenericCalculateConfigFingerprint::vOnServiceTimeout()");
}

//-----------------------------------------------------------------------------

tDiaResult
RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo ( const dia_FingerprintInfo fingerprintData[], const tU16 numOfInfo )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGenericCalculateConfigFingerprint::loadFingerprintInfo");
   tDiaResult retCode = DIA_FAILED;

   // empty vector; otherwise it would be extended
   mFingerprintInfoRep.clear();

   if (( fingerprintData ) && ( numOfInfo > 0 ))
   {
      for ( tU16 i=0; i<numOfInfo; i++ )
      {
         mFingerprintInfoRep.push_back(fingerprintData[i]);
      }
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

} //namespace dia
