/**
 * \file      dia_RoutineCtrlEMPrint2Trace.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Oct 21, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EM_PRINT_2_TRACE_H_
#include "common/services/uds/generic/dia_RoutineCtrlEMPrint2Trace.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

namespace dia
{

RoutineCtrlEMPrint2Trace::RoutineCtrlEMPrint2Trace (tCString name, tU16 udsID, dia_eRoutineID routineID)
   : dia_Routine(name, udsID, routineID, DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlEMPrint2Trace::dia_RoutineCtrlEMPrint2Trace()");
}

//------------------------------------------------------------------------------

RoutineCtrlEMPrint2Trace::~RoutineCtrlEMPrint2Trace ( void )
{
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlEMPrint2Trace::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlEMPrint2Trace::start()");
   bool success = false;

   // prepare processing of the routine
   vInitialize();

   size_t numInBytes = params.size();

   if (0!=numInBytes)
   {
      DIA_TR_ERR("dia_RoutineCtrlEMPrint2Trace::start numInBytes = %zu", numInBytes );
      return DIA_FAILED;
   }

   OSAL_tIODescriptor fd;

   fd = OSAL_IOOpen(OSAL_C_STRING_DEVICE_PRM, OSAL_EN_READONLY);
   if (OSAL_ERROR==fd)
   {
      DIA_TR_ERR("OSAL_IOOpen FAILED");
   }
   else
   {
      tS32 s32Dummy = 0;
      if (OSAL_ERROR==OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_PRM_TRIGGER_ERRMEM_TTFIS, s32Dummy))
      {
         DIA_TR_ERR("OSAL_s32IOControl FAILED");
      }
      else
      {
         DIA_TR_INF("OSAL_s32IOControl OSAL_C_S32_IOCTRL_PRM_TRIGGER_ERRMEM_TTFIS=0x%x succeeded", OSAL_C_S32_IOCTRL_PRM_TRIGGER_ERRMEM_TTFIS );
         success = true;
      }

      if (OSAL_OK!=OSAL_s32IOClose(fd))
      {
         DIA_TR_ERR("OSAL_s32IOClose(0x%lx) FAILED", (unsigned long)fd);
      }
   } //lint !e550: Symbol not accessed, but required to pass a valid parameter in function call


   // Variable for Service Handler Framework that this job is done //! indicate that we are done
   mIsResultReady = TRUE;

   if (success==true)
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }
   else
   {
      DIA_TR_ERR("DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   return DIA_SUCCESS;
}

tDiaResult
RoutineCtrlEMPrint2Trace::requestResult( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlEMPrint2Trace::requestResult()");

   results.push_back(mapStatus2UDSResult());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void
RoutineCtrlEMPrint2Trace::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlEMPrint2Trace::vOnServiceTimeout()");

   eSetStatus(DIA_EN_RTCTRL_STATUS_TIMED_OUT);

#ifndef __DIA_UNIT_TESTING__
   dia_RoutineCtrlManager* pRTCtrlMgr = getInstanceOfRoutineControlManager();

   if ( pRTCtrlMgr )
   {
       pRTCtrlMgr->vOnRoutineUpdate(*this);
   }
#endif
}

} //namespace dia
