/*
 * dia_NRCGenerator.h
 *
 *  Created on: 10.09.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_NRC_GENERATOR__
#define __INCLUDED_DIA_NRC_GENERATOR__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include <common/framework/protocols/uds/dia_ServiceHandlerUDS.h>
#endif

class dia_NRCGenerator
   : public dia_ServiceHandlerUDS
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_NRCGenerator);

public:
   //! singleton constructor that creates a single instance for the given nrc value
   static dia_ServiceHandler* getInstance ( tDiaResult errorCode );
   //! singleton destructor that destroys the single instance for the given nrc value
   static void deleteInstance ( tDiaResult errorCode );
   //! singleton destructor that destroys  a single instance for the given nrc value
   static void deleteInstances ( void );

   //! process the requested service
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

protected:
   //! class constructor to be used
   dia_NRCGenerator ( tU8 nrc );
   //! class destructor
   virtual ~dia_NRCGenerator ( void );

protected:
   //! repository of NCRGenerator instances
   static std::map<tU8,dia_NRCGenerator*> mGeneratorRep;
   //! NRC value to be used for autogenerated negative response
   tU8 mNRC;
};

// factory methods
dia_ServiceHandler* getInstanceOfNRCGenerator ( tDiaResult errorCode );
void releaseInstanceOfNRCGenerator ( tDiaResult errorCode );
void releaseInstancesOfNRCGenerator ( void );

#endif /* __INCLUDED_DIA_NRC_GENERATOR__ */
