/*****************************************************************************************
 *
 * \file    dia_ListToUds.h
 *
 * \brief   provide template-function dia_diaListToUds
 *
 * \details -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright Robert Bosch Car Multimedia 2018
 *
****************************************************************************************/
#ifndef __INCLUDED_DIA_LIST_TO_UDS__
#define __INCLUDED_DIA_LIST_TO_UDS__

namespace dia {

template<class DIATYPE, class UDSTYPE>
bool dia_diaListToUds(std::vector<DIATYPE> const &dia, UDSTYPE& uds, size_t numElem) {
   for (uint32_t i=0; i<numElem;++i) {
      if (i<dia.size()) {
         dia_diaToUds((DIATYPE const &)dia[i], uds);
      } else {
         DIATYPE diaElem;
         dia_diaToUds(diaElem, uds);
      }
   }
   return true;
}

}
#endif
