/*
 * dia_interfaces.h
 *
 *  Created on: 07.09.2012
 *      Author: gib2hi
 * --------------------------------------------------------
 * Date             | Author         | Modification
 * 9.12.15          | nce5kor        | Added interface identifer for BT_device List(AIVI-13213)
 * 22.12.15         | bsu9kor        | Added interface identifier for HMI Language (AIVI-15590)
 * 11.03.16         | gpu2kor        | Added interface identifier for SWC (NCG3D-8789)
 * 13.04.16         | jas1hi         | Added interface identifier for HMIMonitor (AIVINS2-17117)
 * 26.05.16			| bma9kor			| Added interface identifier for Audio Balance and Fader (CMG3G-10183)
 * --------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_INTERFACES__
#define __INCLUDED_DIA_INTERFACES__

/**
 *  \enum dia_enIID
 *
 *  \brief enumeration of diagnosis interface identifiers
 *
 *  \details Every interface has unique ID. The following enumeration provides interface IDs unique for all CM projects.
 *
 *  \ingroup diagFramework
 */

#define IID_SYSADAPTER_SYSTEM_FRAMEWORK_CCA               ((dia::IID) 0xe63c179c) // {669A8BA9-6096-49C3-AE50-73B31AE464E5}
#define IID_SYSADAPTER                                    ((dia::IID) 0x5b225bdd) // {59F990F2-46EE-4886-85EB-11281059F1FD}
#define IID_SYSADAPTER_LISTENER                           ((dia::IID) 0x928d2a32) // {29D9396C-6CC4-42D6-9B3E-9CBB74A83235}
#define IID_SYSADAPTER_MEDIA_USB_MASS_STORAGE             ((dia::IID) 0xf5d229fb) // {07E6124F-486E-4C99-866B-89E9158E555D}
#define IID_SYSADAPTER_MEDIA_IPOD                         ((dia::IID) 0x4b862383) // {C04ED6CB-8482-4807-8AD6-72DCCC051CE7}
#define IID_SYSADAPTER_MEDIA_MEMORY_CARD_STATUS           ((dia::IID) 0x6784ab8b) // {77F12339-C652-499D-942C-FB6B30B7CF0C}
#define IID_SYSADAPTER_MEDIA_MEMORY_CARD_STATUS_LISTENER  ((dia::IID) 0x6040646e) // {4DF17378-1071-455F-9A03-7AABAF6DF03F}
#define IID_SYSADAPTER_KEY                                ((dia::IID) 0xd5d0c188) // {C3AB54B7-548A-473A-A002-D31EDC7B315B}
#define IID_SYSADAPTER_CONTROL_PANEL                      ((dia::IID) 0x63b6315b) // {D4B42102-CC25-4357-8738-2499D6552D56}
#define IID_SYSADAPTER_SDCARD_READTEST                    ((dia::IID) 0x304a7942) // {58C69D52-A191-446D-9419-1DBFD0288483}
#define IID_SYSADAPTER_SDCARD_MEDIASTATUS                 ((dia::IID) 0x4c0acc80) // {38594CF1-F0B5-4391-9B1F-0D7AD8CB33AD}
#define IID_SYSADAPTER_SDCARD_CHECKDISK                   ((dia::IID) 0xfb8eb05c) // {A2D4889A-D1F2-4788-A0E0-1158F2F858D2}
#define IID_SYSADAPTER_BLUETOOTH_MOST                     ((dia::IID) 0x5fc446b2) // {BEAD6CAE-C787-4ABE-B954-B510A40CB45B}
#define IID_SYSADAPTER_BLUETOOTH_MOST_LISTENER            ((dia::IID) 0x27ab8f9c) // {4E2027EF-BC5F-443F-93FA-813B459E32E9}
#define IID_SYSADAPTER_DOWNLOAD_SOFTWARE                  ((dia::IID) 0x4ee4188b) // {E00DCA75-C4EF-4D79-B776-8A2E827B346A}
#define IID_SYSADAPTER_DOWNLOAD_SOFTWARE_LISTENER         ((dia::IID) 0xab65cb5b) // {FA42CDE7-6875-4993-B34E-B5AD98F65B8A}
#define IID_SYSADAPTER_REARVIEWCAMERA                     ((dia::IID) 0x48090244) // {0130EBC9-C496-40CC-B167-79739672D14A}
#define IID_SYSADAPTER_REARVIEWCAMERA_LISTENER            ((dia::IID) 0xc99e7d9f) // {9D6B5D17-8E07-4C6D-9151-0848E80B72BE}
#define IID_SYSADAPTER_DEFSET                             ((dia::IID) 0x9b0a13f9) // {CEBBE5FF-B426-4481-83FE-CA7656DC27DA}
#define IID_SYSADAPTER_DEFSET_PROPERTY_BASED              ((dia::IID) 0x6a5d918c) // {C68E9B96-017D-4414-A5D1-63B130EB4EDD}
#define IID_PRODUCTION_MODE                               ((dia::IID) 0xbad14887) // {CB05E222-6CE4-4094-99FA-A105251FF334}
#define IID_PRODUCTION_MODE_LISTENER                      ((dia::IID) 0x49a892d1) // {492D34B5-14D0-415D-A1BB-B961EC83C361}
#define IID_TUNER_DIAGNOSIS                               ((dia::IID) 0x163530c6) // {3579C5D3-AE81-4882-94C5-457AFDBDE1F7}
#define IID_TUNER_DIAGNOSIS_LISTENER                      ((dia::IID) 0xc7131d92) // {420F930F-AFB2-4925-A925-7FE9C6B895D3}
#define IID_HMI                                           ((dia::IID) 0xb810bf54) // {9B7C261B-A88B-45B5-8467-CC44258EF3F6}
#define IID_HMI_LISTENER                                  ((dia::IID) 0xc2749484) // {9272C31C-AD6F-41DB-906B-9662B4484290}
#define IID_HMI_AUDIO_SOURCE                              ((dia::IID) 0x8f09ac9d) // {914C3BD0-786F-4C74-9C76-E9AF52FCAE98}
#define IID_HMI_AUDIO_SOURCE_LISTENER                     ((dia::IID) 0xfccecc24) // {F3B913F1-A6B1-4E6E-9E4F-6ADB083077D4}
#define IID_PRODUCTION_DRIVER                             ((dia::IID) 0x0d6bed20) // {EC94769F-475C-48BA-B804-0FA91556255A}
#define IID_CUSTOMER_DRIVER                               ((dia::IID) 0xac014a57) // {15278AFA-2A36-4F88-AF09-8F26E2BE02F5}
#define IID_MEDMGR                                        ((dia::IID) 0x04d056a8) // {9983F3E9-854C-49CE-911F-3A63AAED907A}
#define IID_MEDMGR_LISTENER                               ((dia::IID) 0x75a9051b) // {8A9BC2D9-9099-411A-AF2E-95F2EC0220AA}
#define IID_SPEECHREC                                     ((dia::IID) 0x269b56ba) // {1B025405-C3E8-4471-B864-F7E7948722DB}
#define IID_SPEECHREC_LISTENER                            ((dia::IID) 0xcdff53fd) // {691D93FA-99F8-4FC3-95C5-E3C6AC505484}
#define IID_STREAMROUTER                                  ((dia::IID) 0x1c51a890) // {10EB80D0-63AA-4E5D-9CF0-2DCD594ADACD}
#define IID_STREAMROUTER_LISTENER                         ((dia::IID) 0x22ef7db7) // {CBBD8CE6-9069-4917-A8A1-74254F5C7F57}
#define IID_SYSADAPTER_NEONODE                            ((dia::IID) 0x913bac78) // {EE26A2A2-F336-4BDD-92CC-02EB77CCB3FF}
#define IID_SYSADAPTER_NEONODE_LISTENER                   ((dia::IID) 0xf1b01a0e) // {77842A8B-F4C8-48B4-A1DF-766C0D53F812}
#define IID_TCU                                           ((dia::IID) 0x03e98f21) // {A89B5328-C9F5-413B-BED5-F51DB8E366EF}
#define IID_TCU_LISTENER                                  ((dia::IID) 0x324ee438) // {90A75AC0-C7C4-4B0B-9FA4-2150EFEE2287}
#define IID_UNIT_TEST                                     ((dia::IID) 0x07939c03) // {6DB3686A-D730-4216-9ACF-D10646589867}
#define IID_UNIT_TEST_LISTENER                            ((dia::IID) 0x2baf5be2) // {3DF86BA2-5DE5-418E-AA0E-44E2523A2B5B}
#define IID_UNIT_TEST2                                    ((dia::IID) 0xa8a0910c) // {020F4CD1-2184-4D0B-877A-1DFA2ECF02D5}
#define IID_UNIT_TEST_LISTENER2                           ((dia::IID) 0x5176b8e8) // {5687E47F-1B26-47F9-AD71-E7FA0F2738EC}
#define IID_NISSAN_LANGUAGE                               ((dia::IID) 0xc1133887) // {C0DD7DFD-41FD-416A-A966-65BBA397D28D}
#define IID_NISSAN_LANGUAGE_LISTENER                      ((dia::IID) 0x5a4f257a) // {2205E7F0-E87F-4B1F-ACF4-E2E792B08863}
#define IID_SWC                                           ((dia::IID) 0x0e4c8954) // {7F354EE9-AA3F-4C39-A68D-5FA8EF72F789}
#define IID_SWC_LISTENER                                  ((dia::IID) 0xad5c753d) // {C6EE20A0-B949-4D4E-ACBC-B51C8299F4C0}
#define IID_IT_COMMANDER                                  ((dia::IID) 0x6768af00) // {ABDEE16B-27B1-4B6F-B401-12891A1F61FF}
#define IID_IT_COMMANDER_LISTENER                         ((dia::IID) 0x12f13901) // {54453885-BAC8-4F7D-A00C-8929DF1FB65E}
#define IID_HMI_MONITOR                                   ((dia::IID) 0x158df0fe) // {CDD1A8AD-D8C8-4C86-820F-D61B7A4A71C2}
#define IID_HMI_MONITOR_LISTENER                          ((dia::IID) 0xd4979b43) // {BBB035AE-F327-4E26-AA96-5370E5A1516C}
#define IID_SDS_GUI_POPUP                                 ((dia::IID) 0xe8626e5a) // {14BBF1A3-5ACE-4F1F-95B5-A7DB33508C8E}
#define IID_SDS_GUI_POPUP_LISTENER                        ((dia::IID) 0xc7f06dad) // {2AE47557-2302-4BFD-AD84-9460A588648E}
#define IID_HMI_NAVIGATION                                ((dia::IID) 0x3568f40c) // {24B5A07E-EFDE-4E72-AE2A-5DAC20A6D24B}
#define IID_HMI_NAVIGATION_LISTENER                       ((dia::IID) 0xdfb6e783) // {FBEA85A1-640F-47FC-84D1-30DEEA3C67D7}
#define IID_PHONE_CONNECTION_SETTING                      ((dia::IID) 0x941dd7b8) // {24DC34A3-E6A0-4CD6-A6F2-65DEF05EB74B}
#define IID_PHONE_CONNECTION_SETTING_LISTENER             ((dia::IID) 0xf27e0eb1) // {2830AF62-1420-4A2A-A47C-1B624D376C88}

//##################################################################################################

#define DIA_DECL_INTERFACE_UID(uid)                      \
public:                                                  \
   static dia::IID getUID ( void ) { return (dia::IID) uid; }

#define DIA_DECL_INTERFACE_VERSION_MAJOR(versionMajor)   \
public:                                                  \
   static tU16 getVersionMajor ( void ) { return versionMajor; }

#define DIA_DECL_INTERFACE_VERSION_MINOR(versionMinor)   \
public:                                                  \
   static tU16 getVersionMinor ( void ) { return versionMinor; }

#define DIA_DECL_INTERFACE_VERSION_PATCH(versionPatch)   \
public:                                                  \
   static tU16 getVersionPatch ( void ) { return versionPatch; }

#define DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(versionMajor,versionMinor) \
public:                                                  \
   static tU16  getVersionMajor ( void ) { return versionMajor; } \
   static tU16  getVersionMinor ( void ) { return versionMinor; } \
   static tU16  getVersionPatch ( void ) { return 0; } \
   static void  getVersion ( tU16& major, tU16& minor, tU16& patch ) { major = versionMinor; minor = versionMinor; patch = 0; }

#define DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR_PATCH(versionMajor,versionMinor,versionPatch) \
public:                                                  \
   static tU16  getVersionMajor ( void ) { return versionMajor; } \
   static tU16  getVersionMinor ( void ) { return versionMinor; } \
   static tU16  getVersionPatch ( void ) { return versionPatch; } \
   static void  getVersion ( tU16& major, tU16& minor, tU16& patch ) { major = versionMinor; minor = versionMinor; patch = versionPatch; }

#define DIA_DECL_SYSADAPTER_UID(uid)                     \
public:                                                  \
   static dia::IID getUID ( void ) { return (dia::IID) uid; }

#define DIA_DECL_INTERFACE_IID(uid)                      \
public:                                                  \
   static dia::IID getUID ( void ) { return (dia::IID) uid; }

#define DIA_DECL_CONFIGMANAGER_IID(iid) \
public:                                 \
    static dia::IID getIID ( void ) { return iid; }

#endif
