#ifndef __INCLUDED_DIA_UTILITIES__
#define __INCLUDED_DIA_UTILITIES__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#include <sstream> //lint !e537  repeatedly included header file without standard include guard

/*
 * Macro ct_assert could be used to check size of a variable at compilation time.
 * For example: ct_assert(sizeof(tU32)<5)
 * Construction "#if (sizeof(tU32)<5)" generates errors and cannot be used, because
 * evaluation of sizeof is done at compilation.
 * */
#define ASSERT_CONCAT_(a, b) a##b
#define ASSERT_CONCAT(a, b) ASSERT_CONCAT_(a, b)
#define ct_assert(e)    /*lint -save -e514 */                              \
                        /*lint -esym(753, unique_tag*) */                  \
                        /*lint -esym(749, unique_tag*::assert_line_*) */   \
                  enum ASSERT_CONCAT(unique_tag, __LINE__) { ASSERT_CONCAT(assert_line_, __LINE__) = 1/(!!(e)) }  \
                        /*lint -restore */

namespace dia_nsUtilities
{
   bool toggleCrc();
   void generateCrc(std::vector<tU8> const&, tU16&, tU32 = 0);
   bool generateHash(std::vector<tU8> const&, std::vector<tU8>&);

   // Conversion Macros
   #define U8_2_U16(u8_high,u8_low)                         ((tU16)(((u8_high)<<8) + ((tU8)(u8_low))))
// #define U8_2_U32(u8_highest,u8_high,u8_low,u8_lowest)    ((tU32)((((tU32) u8_highest) << 24) + (((tU32) u8_high) << 16) + (((tU32) u8_low) << 8) + ((tU8) u8_lowest)))
   #define U8_2_U32(u8_highest,u8_high,u8_low,u8_lowest)    ((((tU32) u8_highest) << 24) | (((tU32) u8_high) << 16) | (((tU32) u8_low) << 8) | ((tU32) u8_lowest))
   #define U16_BYTE1(u16) ((tU8)((u16)>> 8))
   #define U16_BYTE2(u16) ((tU8)((u16)>> 0))
   #define U32_BYTE1(u32) ((tU8)((u32)>>24))
   #define U32_BYTE2(u32) ((tU8)((u32)>>16))
   #define U32_BYTE3(u32) ((tU8)((u32)>> 8))
   #define U32_BYTE4(u32) ((tU8)((u32)>> 0))

   #define GET_BYTE_N(VAL, N) (((VAL)>>((N)<<3))&0xFF)

   //defines for hash
   #define DIA_CONFIG_HASH_BINARY_SIZE                (20)     /* size of SHA1 */
   #define DIA_CONFIG_HASH_STRING_LONG_FORMAT_SIZE    (47)     /* 20*2 ascii + 4 '-' + 2 '{}' + 1 null-terminator */

   tU8 getBinaryFromHexString(char sHex);

   std::string convertArray2HexString ( std::vector<tU8>& data );
   void convertToHashSpecificFormat ( std::vector<tU8>& vectSha1, std::string& strHash );

   tDiaResult readConfiguration( std::vector<tU32>& vPropData, std::vector<tU8>&);
   tDiaResult readConfigItem( std::vector<tU8>& data, tU32 id );
   tDiaResult writeHashLongFormatToRegistry ( const tU8* buffer, tU32 propertyID );
}

namespace dia {
namespace utils {

   std::string vector2string ( const std::vector<tU8>& data );
   std::string bin2str ( const unsigned char* data, int len, char separator = 0 );
   std::string bin2str ( const std::vector<tU8>& data, char separator = 0 );
   std::string bin2hexstr ( const std::vector<tU8>& data, bool hexPrefix=false);
   std::string byte2hexstr ( const tU8 byte, bool hexPrefix=false);
   tU8 hexstr2byte ( const std::string& str );
   tU16 hexstr2word(const std::string& str);
   tDiaResult hexstr2bin(char const *str, uint8_t *bin, size_t binLen);
   tDiaResult hexstr2bin(const std::string& str, std::vector<tU8>& data);  //convert hex string to data vector

   uint16_t getU16(uint8_t const *data); 
   uint32_t getU32(uint8_t const *data); 
   uint64_t getUxx(uint8_t const *data, uint8_t numBytes); 

   void setUxx(uint64_t val, uint8_t numBytes, uint8_t *data); 
   void addUxx(uint64_t val, uint8_t numBytes, std::vector<uint8_t> &data);

   std::string tail(std::string const& source, size_t const length);
   tDiaResult scanFilesInDir(const std::string& folderName, const std::string& key, std::list<std::string>& fileRep);

   template<class _T> std::string toString ( const _T& t )
   {
      std::ostringstream stream;
      stream << t;
      return stream.str();
   }

   template<class _T>
   _T fromString ( const std::string& s )
   {
      std::istringstream stream (s);
      _T t;
      stream >> t;
      return t;
   }

} // utils
} // dia

#endif // DIA_UTILITIES_H
