/*
 * dia_StringComposer.h
 *
 *  Created on: 16.03.2015
 *      Author: GIB2HI
 */

#ifndef __DIA_INCLUDED_STRING_COMPOSER__
#define __DIA_INCLUDED_STRING_COMPOSER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif
#include <string>
class dia_StringComposer
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_StringComposer);

public:
      std::string composeStlStringV ( const char* format, va_list argList );

   //! class destructor
   virtual ~dia_StringComposer ( void );

   //! compose a string a la
   virtual tCString composeString ( const char* format, ... );
   virtual tCString composeStringV ( const char* format, va_list argList );

protected:
   //! default constructor
   dia_StringComposer ( void );

   tChar* trimString ( const char* strBuffer, tU16 strLength ) const;
};

dia_StringComposer* getInstanceOfStringComposer ( void );
void releaseInstanceOfStringComposer ( void );

tCString dia_composeString ( const char* format, ... );
std::string dia_composeStlString ( const char* format, ... );


#endif /* __DIA_INCLUDED_STRING_COMPOSER__ */
