/*
 * dia_StringComposer.cpp
 *
 *  Created on: 16.03.2015
 *      Author: GIB2HI
 */

#include "stdlib.h"
#include "stdarg.h"

#ifndef __DIA_INCLUDED_STRING_COMPOSER__
#include <common/framework/utils/dia_StringComposer.h>
#endif

#define DIA_C_STRING_COMPOSER_MAX_STRING_SIZE   512

DIA_IMPL_SINGLETON(dia_StringComposer)

#ifndef __DIA_UNIT_TESTING__

dia_StringComposer*
getInstanceOfStringComposer ( void )
{
   return dia_StringComposer::getInstance();
}

void
releaseInstanceOfStringComposer ( void )
{
   return dia_StringComposer::deleteInstance();
}

#endif

//-----------------------------------------------------------------------------

dia_StringComposer::dia_StringComposer ( void )
{}

//-----------------------------------------------------------------------------

dia_StringComposer::~dia_StringComposer ( void )
{}

//-----------------------------------------------------------------------------

// DEPRECATED, PLEASE USE THE STL VERSION OF THE StringComposer
tCString
dia_StringComposer::composeString ( const char* format, ... )
// DEPRECATED, PLEASE USE THE STL VERSION OF THE StringComposer
{
   va_list argList;
   va_start(argList,format);
   tCString pStr = composeStringV(format,argList);
   va_end(argList);
   return pStr;
}
// DEPRECATED, PLEASE USE THE STL VERSION OF THE StringComposer

//-----------------------------------------------------------------------------

tCString
dia_StringComposer::composeStringV ( const char* format, va_list argList )
{
   tChar strBuffer[DIA_C_STRING_COMPOSER_MAX_STRING_SIZE];
   int numOfChars = vsnprintf(strBuffer, DIA_C_STRING_COMPOSER_MAX_STRING_SIZE, format, argList);
   if ( (numOfChars < 0) || (numOfChars >= DIA_C_STRING_COMPOSER_MAX_STRING_SIZE) ) return 0;
   strBuffer[numOfChars] = '\0';
   return trimString(strBuffer, (tU16) numOfChars);
}

std::string
dia_StringComposer::composeStlStringV ( const char* format, va_list argList )
{
   tChar strBuffer[DIA_C_STRING_COMPOSER_MAX_STRING_SIZE];
   int numOfChars = vsnprintf(strBuffer, DIA_C_STRING_COMPOSER_MAX_STRING_SIZE, format, argList);
   if ( (numOfChars < 0) || (numOfChars >= DIA_C_STRING_COMPOSER_MAX_STRING_SIZE) ) return 0;
   strBuffer[numOfChars] = '\0';
  return std::string(strBuffer);
}

//-----------------------------------------------------------------------------

tChar*
dia_StringComposer::trimString ( const char* strBuffer, tU16 strLength ) const
{
   tChar* pStr = OSAL_NEW tChar[strLength+1];
   if ( pStr )
   {
      ::memcpy(pStr,strBuffer,strLength);
      pStr[strLength] = '\0';
   }

   return pStr;
}

//-----------------------------------------------------------------------------
// DEPRECATED, PLEASE USE THE STL VERSION OF THE StringComposer
tCString
dia_composeString ( const char* format, ... )
// DEPRECATED, PLEASE USE THE STL VERSION OF THE StringComposer
{
   dia_StringComposer* composer = getInstanceOfStringComposer();
   if ( composer )
   {
      va_list argList;
      va_start(argList,format);
      tCString pStr = composer->composeStringV(format,argList);
      va_end(argList);
      return pStr;
   }
   return 0;
}
// DEPRECATED, PLEASE USE THE STL VERSION OF THE StringComposer

std::string
dia_composeStlString ( const char* format, ... )
{
   dia_StringComposer* composer = getInstanceOfStringComposer();
   if ( composer )
   {
      va_list argList;
      va_start(argList,format);
      std::string str = composer->composeStlStringV(format, argList);
      va_end(argList);
      return str;
   }
   return 0;
}
