/**
 * \file      dia_ProcInfo.h
 *
 * \brief     Functions to query a process' status information
 *
 * \details   {insert file description here}
 *
 * \author    fan4hi
 * \date      Feb 07, 2018
 *
 * \copyright Robert Bosch Car Multimedia 2018
 */

#ifndef __INCLUDED_DIA_PROC_INFO_H_
#define __INCLUDED_DIA_PROC_INFO_H_

namespace dia
{

#define PROCINFO_PROC_NAME_MAX   230
#define PROCINFO_FILE_NAME_MAX   1024

#define PROCINFOFORMAT_SIGNED     'i'
#define PROCINFOFORMAT_UNSIGNED   'u'
#define PROCINFOFORMAT_CHARACTER  'c'
#define PROCINFOFORMAT_HEXDUMP    'h'
#define PROCINFOFORMAT_TIME       't'
#define PROCINFOFORMAT_KBYTES     'k'
#define PROCINFOFORMAT_PAGES      'p'

#define PROCINFOFORMAT_SKIP       'X', ' '
#define PROCINFOFORMAT_SKIPNAME   '(', ')'

#define PROCINFOFORMAT_ENTRY(TYPE, COUNT)    (TYPE), ((COUNT)+'0')

#define PROCINFOFORMAT_END_SEQUENCE  0

class ProcInfo
{
public:
   ProcInfo();
   ~ProcInfo();

   //! Get the PID(s) of a process
   int   GetPID(const char *ProcName);
   //! Reads /proc/<PID>/stat and parses the content according to Format
   bool  ParseStatValues(std::vector<tU8> &Buffer, int PID, const char *Format);
   //! Reads /proc/<PID>/statm and parses the content according to Format
   bool  ParseStatMValues(std::vector<tU8> &Buffer, int PID, const char *Format);
   //! Parses the content String according to Format
   bool  ParseStatString(std::vector<tU8> &Buffer, const char *Format, char *String);

protected:
   bool  ParseInt64(int64_t *Out, const char *Str);
   bool  ParseUInt64(uint64_t *Out, const char *Str);
   void  BufferMotorolaFormat(std::vector<tU8> &Buffer, uint64_t Value, unsigned int Bytes);

   std::vector<int>  _pid;
   unsigned int      _pid_cnt;
};

} // namespace dia

#endif // __INCLUDED_DIA_PROC_INFO_H_
