/**
 * \file      dia_SimpleUpdatePlugin.cpp
 *
 * \brief     {process the file line by line}
 *
 * \details   {process the file line by line}
 *
 * \author    bhs1hi
 * \date      Jan 25, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SIMPLE_UPDATE_PLUGIN__
#include "dia_SimpleUpdatePlugin.h"
#endif

#ifndef __INCLUDED_DIA_LINE_PARSER__
#include "common/framework/update/dia_LineParser.h"
#endif

//-----------------------------------------------------------------------------

dia_SimpleUpdatePlugin::dia_SimpleUpdatePlugin ( dia_LineParser* pLineParser )
   : mpParser(pLineParser),
   mIsHWIndexExists(false)

{
   memset(diag_filename,'\0',FILENAME_LENGTH);
   dia_tclFnctTrace trc("dia_SimpleUpdatePlugin::dia_SimpleUpdatePlugin");
   DIA_TR_INF("dia_SimpleUpdatePlugin::dia_SimpleUpdatePlugin");
}

//-----------------------------------------------------------------------------

dia_SimpleUpdatePlugin::~dia_SimpleUpdatePlugin ( void )
{
   //dia_tclFnctTrace trc("dia_SimpleUpdatePlugin::~dia_SimpleUpdatePlugin");
   //DIA_TR_INF("dia_SimpleUpdatePlugin::~dia_SimpleUpdatePlugin");
   mpParser = 0;
}

//-----------------------------------------------------------------------------

tDiaResult
//dia_SimpleUpdatePlugin::processUpdate ( const dia_File& file, const dia_LineParser& lineParser  )
dia_SimpleUpdatePlugin::processUpdate ( void )
{
   dia_tclFnctTrace trc("dia_SimpleUpdatePlugin::processUpdate");

   //printf("dia_SimpleUpdatePlugin : processUpdate Entry\n\n");
   DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate Entry");
   tDiaResult retCode = DIA_FAILED;

   tU32 u32LineSize = 0;
   //tU32 counter = 0;
   tChar* s8RawBuf = OSAL_NEW tChar[DIA_PROP_LENGTH_MAX];

   if (setDiagFileName() != DIA_SUCCESS )
   {
       DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate: set file name is failed");
       OSAL_DELETE [] s8RawBuf;
       return retCode;
   }

   tU32 u32FilePathSize = (tU32) strlen (diag_filename);
   DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate - FilePathSize 0x%04x OR %d", u32FilePathSize, u32FilePathSize);

   //if ( u32FilePathSize != (FILENAME_LENGTH - 1) )
   //{
   //    DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate: file+path length is incorrect");
   //    OSAL_DELETE [] s8RawBuf;
   //    return retCode;
   //}
   if ( mIsHWIndexExists == true )
   {
      if ( u32FilePathSize != (FILENAME_LENGTH - 1) )
      {
          DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate: file+path length is incorrect with HW index");
          OSAL_DELETE [] s8RawBuf;
          return retCode;
      }
   }
   else
   {
      if ( u32FilePathSize != (FILENAME_LENGTH - 7) )
      {
          DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate: file+path length is incorrect without HW index");
          OSAL_DELETE [] s8RawBuf;
          return retCode;
      }
   }

   dia_File file(diag_filename);

   if (file.open("r") == DIA_SUCCESS)
   {
      DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate 1");

      while ( (!( file.endOfFile( ))) /*&& (counter < 100)*/)
      {
         DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate 2");
         if ( ( file.getLine( s8RawBuf, DIA_PROP_LENGTH_MAX, &u32LineSize ) ) == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate 3");

            DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate - s8RawBuf line %s", s8RawBuf);
            DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate - u32LineSize length %d", u32LineSize);

            if(1 < u32LineSize)
            {
               retCode = mpParser->parseLine( s8RawBuf, (u32LineSize - 1) );
            }
            else
            {
               DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate - u32LineSize less than 2");
               OSAL_DELETE [] s8RawBuf;
               return retCode;
            }
            DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate 4");
         }
         else
         {
            DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate: Read Line is failed");
            break;
         }

         //counter++;
      }

      //close the file
      if (file.close( ) != DIA_SUCCESS)
      {
          DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate: ERROR WHILE CLOSING THE FILE");
      }
      //delete the file from FFS
      if (file.remove( ) != DIA_SUCCESS)
      {
          DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate: file delete FAILED!!");
      }

   }
   DIA_TR_INF("dia_SimpleUpdatePlugin::processUpdate 5");
   OSAL_DELETE[] s8RawBuf;
   return retCode;
}

//-----------------------------------------------------------------------------
tDiaResult
dia_SimpleUpdatePlugin::setDiagFileName(void)
{
   dia_tclFnctTrace trc("dia_SimpleUpdatePlugin::setDiagFileName");

   DIA_TR_INF("dia_SimpleUpdatePlugin::setDiagFileName entry");
   tDiaResult retCode = DIA_SUCCESS;

   tU8 u8data[21] = {0};
   (void) ::memset(u8data, 0, 21);

   if ( dia_getProperty(DIA_PROP_CM_ECU_SPARE_PART_NR, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CM_ECU_SPARE_PART_NR)) ) == DIA_SUCCESS )
   {
       DIA_TR_INF("dia_SimpleUpdatePlugin::setDiagFileName: read success (DIA_PROP_CM_ECU_SPARE_PART_NR).");
   }
   else
   {
       retCode = DIA_FAILED;
       DIA_TR_INF("dia_SimpleUpdatePlugin::setDiagFileName: read fail (DIA_PROP_CM_ECU_SPARE_PART_NR).");
       return retCode;
   }

   if ( dia_getProperty(DIA_PROP_CM_ECU_HW_VERSION, (&(u8data [13])), (dia_getPropertySize(DIA_PROP_CM_ECU_HW_VERSION)) ) == DIA_SUCCESS )
   {
       mIsHWIndexExists = true;
       DIA_TR_INF("dia_SimpleUpdatePlugin::setDiagFileName: read success (DIA_PROP_CM_ECU_HW_VERSION).");
   }
   else
   {
       //retCode = DIA_FAILED;
       DIA_TR_INF("dia_SimpleUpdatePlugin::setDiagFileName: read fail (DIA_PROP_CM_ECU_HW_VERSION).");
       //return retCode;
   }

   if ( mIsHWIndexExists == true )
   {
      u8data[10] = '_';
      u8data[11] = 'H';
      u8data[12] = 'W';
      u8data[16] = '.';
      u8data[17] = 'k';
      u8data[18] = 'd';
      u8data[19] = 's';
      u8data[20] = '\0';
   }
   else
   {
      u8data[10] = '.';
      u8data[11] = 'k';
      u8data[12] = 'd';
      u8data[13] = 's';
      u8data[14] = '\0';
   }

   DIA_TR_INF( "DOWNLOAD FILE NAME : %s ", (tCString)u8data);

   // filename will be  7503200015_HW070.kds
   // path is "/var/opt/bosch/dynamic/diagnosis/configupdate/"
   sprintf((tChar*)diag_filename, DIAG_DNL_PATH"%s", (tChar*)u8data);

   DIA_TR_INF( "DOWNLOAD FILE NAME ALONG WITH THE PATH : %s ", (tCString)diag_filename);

   return retCode;

}
