/**
 * \file      dia_SimpleDataSetUpdatePlugin.cpp
 *
 * \brief     {process the file line by line}
 *
 * \details   {process the file line by line}
 *
 * \author    nbs3kor
 * \date      Nov 10, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef __INCLUDED_DIA_SIMPLE_DATASET_UPDATE_PLUGIN__
#include "dia_SimpleDataSetUpdatePlugin.h"
#endif

#ifndef __INCLUDED_DIA_LINE_PARSER__
#include "common/framework/update/dia_LineParser.h"
#endif

#define UPDATE_PLUGIN_BUFF_SIZE  (10*1000)

//-----------------------------------------------------------------------------

dia_SimpleDataSetUpdatePlugin::dia_SimpleDataSetUpdatePlugin ( dia_LineParser* pLineParser )
   : mpParser(pLineParser),
   mIsHWIndexExists(false)

{
   memset(diag_DataSet_filename,'\0',DATASET_FILENAME_LENGTH);
   dia_tclFnctTrace trc("dia_SimpleDataSetUpdatePlugin::dia_SimpleDataSetUpdatePlugin");
   DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::dia_SimpleDataSetUpdatePlugin");
}

//-----------------------------------------------------------------------------

dia_SimpleDataSetUpdatePlugin::~dia_SimpleDataSetUpdatePlugin ( void )
{
   //dia_tclFnctTrace trc("dia_SimpleDataSetUpdatePlugin::~dia_SimpleDataSetUpdatePlugin");
   //DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::~dia_SimpleDataSetUpdatePlugin");
   mpParser = 0;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SimpleDataSetUpdatePlugin::processUpdate ( void )
{
   dia_tclFnctTrace trc("dia_SimpleDataSetUpdatePlugin::processUpdate");

   DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate Entry");
   tDiaResult retCode = DIA_FAILED;

   tU32 u32LineSize = 0;
   tChar* s8RawBuf = OSAL_NEW tChar[UPDATE_PLUGIN_BUFF_SIZE];

   if (setDiagDataSetFileName() != DIA_SUCCESS )
   {
       DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate: set file name is failed");
       OSAL_DELETE [] s8RawBuf;
       return retCode;
   }

   tU32 u32FilePathSize = (tU32) strlen (diag_DataSet_filename);
   DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate - FilePathSize 0x%04x OR %d", u32FilePathSize, u32FilePathSize);


   if ( mIsHWIndexExists == true )
   {
      if ( u32FilePathSize != (DATASET_FILENAME_LENGTH - 1) )
      {
          DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate: file+path length is incorrect with HW index");
          OSAL_DELETE [] s8RawBuf;
          return retCode;
      }
   }
   else
   {
      if ( u32FilePathSize != (DATASET_FILENAME_LENGTH - 6) )
      {
          DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate: file+path length is incorrect without HW index");
          OSAL_DELETE [] s8RawBuf;
          return retCode;
      }
   }

   dia_File file(diag_DataSet_filename);

   if (file.open("r") == DIA_SUCCESS)
   {
      DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate 1");

      while ( (!( file.endOfFile( ))) /*&& (counter < 100)*/)
      {
         DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate 2");
         if ( ( file.getLine( s8RawBuf, UPDATE_PLUGIN_BUFF_SIZE, &u32LineSize ) ) == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate 3");

            DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate - s8RawBuf line %s", s8RawBuf);
            DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate - u32LineSize length %d", u32LineSize);

         if(1 < u32LineSize)
         {
            retCode = mpParser->parseLine( s8RawBuf, (u32LineSize - 2) );
         }
         else
         {
            DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate - u32LineSize less than 2");
            OSAL_DELETE [] s8RawBuf;
            return retCode;
         }
            DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate 4");
         }
         else
         {
            DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate: Read Line is failed");
            break;
         }

         //counter++;
      }

      //close the file
      if (file.close( ) != DIA_SUCCESS)
      {
          DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate: ERROR WHILE CLOSING THE FILE");
      }
      //delete the file from FFS
      if (file.remove( ) != DIA_SUCCESS)
      {
          DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate: file delete FAILED!!");
      }

   }
   DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::processUpdate 5");
   OSAL_DELETE[] s8RawBuf;
   return retCode;
}

//-----------------------------------------------------------------------------
tDiaResult
dia_SimpleDataSetUpdatePlugin::setDiagDataSetFileName(void)
{
   dia_tclFnctTrace trc("dia_SimpleDataSetUpdatePlugin::setDiagDataSetFileName");

   DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::setDiagDataSetFileName entry");
   tDiaResult retCode = DIA_SUCCESS;

   tU8 u8data[20] = {0};
   (void) ::memset(u8data, 0, 20);

   if ( dia_getProperty(DIA_PROP_CM_ECU_SPARE_PART_NR, (&(u8data [0])), (dia_getPropertySize(DIA_PROP_CM_ECU_SPARE_PART_NR)) ) == DIA_SUCCESS )
   {
       DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::setDiagDataSetFileName: read success (DIA_PROP_CM_ECU_SPARE_PART_NR).");
   }
   else
   {
       retCode = DIA_FAILED;
       DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::setDiagDataSetFileName: read fail (DIA_PROP_CM_ECU_SPARE_PART_NR).");
       return retCode;
   }

   if ( dia_getProperty(DIA_PROP_CM_ECU_HW_VERSION, (&(u8data [13])), (dia_getPropertySize(DIA_PROP_CM_ECU_HW_VERSION)) ) == DIA_SUCCESS )
   {
       mIsHWIndexExists = true;
       DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::setDiagDataSetFileName: read success (DIA_PROP_CM_ECU_HW_VERSION).");
   }
   else
   {
       //retCode = DIA_FAILED;
       DIA_TR_INF("dia_SimpleDataSetUpdatePlugin::setDiagDataSetFileName: read fail (DIA_PROP_CM_ECU_HW_VERSION).");
       //return retCode;
   }

   if ( mIsHWIndexExists == true )
   {
       u8data[10] = '_';
       u8data[11] = 'H';
       u8data[12] = 'W';
      u8data[16] = '.';
      u8data[17] = 'd';
      u8data[18] = 's';
         u8data[19] = '\0';
   }
   else
   {
      u8data[10] = '.';
      u8data[11] = 'd';
      u8data[12] = 's';
         u8data[13] = '\0';
   }

   DIA_TR_INF("DOWNLOAD FILE NAME : %s ", (tCString)u8data);

   // filename will be  7503200015_HW070.dp
   // path is "/var/opt/bosch/dynamic/diagnosis/configupdate/"
   sprintf((tChar*)diag_DataSet_filename, DIAG_DATASET_DNL_PATH"%s", (tChar*)u8data);

   DIA_TR_INF( "DataSet : DOWNLOAD FILE NAME ALONG WITH THE PATH : %s ", (tCString)diag_DataSet_filename);

   return retCode;

}
