/**
 * \file      dia_LineParser.h
 *
 * \brief     {VW Config update}
 *
 * \details   {VW Config update : KDS}
 *
 * \author    bhs1hi
 * \date      Jan 24, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_LINE_PARSER__
#define __INCLUDED_DIA_LINE_PARSER__

class dia_LineParser
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_LineParser);

public:
   //! class constructor
   dia_LineParser ( void );
   //! class destructor
   virtual ~dia_LineParser ( void );

   //! parse the given line and extract the contents like - key, length and data bytes
   virtual tDiaResult parseLine ( const tChar *line, tU32 u32LineSize ) = 0;
};

#endif /* __INCLUDED_DIA_LINE_PARSER__ */
