/**
 * \file      dia_KdsMapParser.h
 *
 * \brief     {VW Config update}
 *
 * \details   {VW Config update : KDS}
 *
 * \author    bhs1hi
 * \date      Jan 24, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_KDS_MAP_PARSER__
#define __INCLUDED_DIA_KDS_MAP_PARSER__

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_LINE_PARSER__
#include "dia_LineParser.h"
#endif

using namespace dia_nsUtilities;

class dia_KdsMapParser : public dia_LineParser
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_KdsMapParser);

public:
   //! class constructor
   dia_KdsMapParser ( void );
   //! class destructor
   virtual ~dia_KdsMapParser ( void );

   //! parse the given line and extract the contents like - key, length and data bytes
   virtual tDiaResult parseLine ( const tChar *line, tU32 u32LineSize );
};

#endif /* __INCLUDED_DIA_KDS_MAP_PARSER__ */
