/**
 * \file      dia_KdsMapParser.cpp
 *
 * \brief     {VW Config update}
 *
 * \details   {VW Config update : KDS}
 *
 * \author    bhs1hi
 * \date      Jan 24, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_KDS_MAP_PARSER__
#include "dia_KdsMapParser.h"
#endif

#ifndef __INCLUDED_DIA_NATIVE_KDS_INTERFACE__
#include "common/framework/config/dia_IKDS.h"
#endif

//-----------------------------------------------------------------------------

dia_KdsMapParser::dia_KdsMapParser ( void )
{
   dia_tclFnctTrace trc("dia_KdsMapParser::dia_KdsMapParser");
   DIA_TR_INF("dia_KdsMapParser::dia_KdsMapParser");
}

//-----------------------------------------------------------------------------

dia_KdsMapParser::~dia_KdsMapParser ( void )
{
   //dia_tclFnctTrace trc("dia_KdsMapParser::~dia_KdsMapParser");
   //DIA_TR_INF("dia_KdsMapParser::~dia_KdsMapParser");
}

//-----------------------------------------------------------------------------

tDiaResult
dia_KdsMapParser::parseLine ( const tChar *line, tU32 u32LineSize )
{
   dia_tclFnctTrace trc("dia_KdsMapParser::parseLine");

   //printf("dia_KdsMapParser : parseLine Entry\n\n"); 
   DIA_TR_INF("dia_KdsMapParser::parseLine entry");

   tDiaResult retCode = DIA_FAILED;

   if ( u32LineSize != 0 )
   {
      //extract the required characters viz.

      //printf("dia_KdsMapParser : parseLine - 1 \n\n");
      DIA_TR_INF("dia_KdsMapParser::parseLine - 1");

      tChar tempArr [3];
      memset(tempArr,'\0',3);
      tU32 u32Temp = 0;
      tU32 u32iterationCountTwo = 0;

      tU8 u8temp = 0;

      tU8  au8DataBuffer[DIA_PROP_LENGTH_MAX] = { 0 };
      (tVoid) ::memset(au8DataBuffer, 0, DIA_PROP_LENGTH_MAX);

      for( tU32 u32iterationCountOne = 0; u32iterationCountOne < u32LineSize; u32iterationCountOne+=3)
      {
         //printf("dia_KdsMapParser : parseLine - 2 \n\n");
         DIA_TR_INF("dia_KdsMapParser::parseLine - 2");
         (tVoid) OSAL_szStringNCopy (&(tempArr[0]), &(line[u32iterationCountOne]), 2);
         tempArr[2] = '\0';

         sscanf( tempArr, "%x", (tS32*) (&u32Temp) );
         au8DataBuffer[u32iterationCountTwo] = (tU8)u32Temp;
         u8temp = au8DataBuffer[u32iterationCountTwo];
         u32iterationCountTwo = u32iterationCountTwo + 1;
         DIA_TR_INF("dia_KdsMapParser::parseLine - Data (%d) : au8DataBuffer 0x%02x OR %d", (u32iterationCountTwo), u8temp, u8temp);
      }
      //printf("dia_KdsMapParser : parseLine - 3 \n\n");
      DIA_TR_INF("dia_KdsMapParser::parseLine - 3");
      
      tU16 u16KDSAddress = U8_2_U16 (au8DataBuffer[0], au8DataBuffer[1]);
      tU16 u16KDS_Size = (tU16) (au8DataBuffer[2]);
      DIA_TR_INF("dia_KdsMapParser::parseLine - u16KDSAddress 0x%04x OR %d", u16KDSAddress, u16KDSAddress);
      DIA_TR_INF("dia_KdsMapParser::parseLine - u16KDS_Size 0x%04x OR %d", u16KDS_Size, u16KDS_Size);
      DIA_TR_INF("dia_KdsMapParser::parseLine - u32iterationCountTwo %d", u32iterationCountTwo);

      if ( (au8DataBuffer[2] != 0x00) && (au8DataBuffer[2] == (u32iterationCountTwo - 3)) )
      {
         //printf("dia_KdsMapParser : parseLine - 4 \n\n");
         DIA_TR_INF("dia_KdsMapParser::parseLine - 4");
         dia_IKDS* pKDS = 0;
         if (queryConfMgrInterface<dia_IKDS>(&pKDS) == DIA_SUCCESS)
         {
            //printf("dia_KdsMapParser : parseLine - 5 \n\n");
            DIA_TR_INF("dia_KdsMapParser::parseLine - 5");
            DIA_TR_INF("dia_KdsMapParser::parseLine - Try Write Data into KDS entry 0x%04x with length %d", u16KDSAddress, u16KDS_Size);

            if (pKDS->writeKDS(u16KDSAddress, (&(au8DataBuffer [3])), u16KDS_Size) == DIA_SUCCESS)
            {
                //printf("dia_KdsMapParser : parseLine - 6 \n\n");
                DIA_TR_INF("dia_KdsMapParser::parseLine - 6");
                DIA_TR_INF("dia_KdsMapParser::parseLine: Write Data into KDS SUCCESSFUL");
                retCode = DIA_SUCCESS;
            }
            else
            {
                //printf("dia_KdsMapParser : parseLine - 7 \n\n");
                DIA_TR_INF("dia_KdsMapParser::parseLine - 7");
                DIA_TR_INF("dia_KdsMapParser::parseLine: Write Data into KDS FAIL");
            }

         }
         else
         {
             //printf("dia_KdsMapParser : parseLine - 8 \n\n");
             DIA_TR_INF("dia_KdsMapParser::parseLine - 8");
             DIA_TR_INF("dia_KdsMapParser::parseLine - Requesting ConfigManager interface failed");
         }
      }
      else
      {
          //printf("dia_KdsMapParser : parseLine - 9 \n\n");
          DIA_TR_INF("dia_KdsMapParser::parseLine - 9");
          DIA_TR_INF("dia_KdsMapParser::parseLine :- No data bytes to write to KDS OR no. of bytes not matching kds size byte");  
      }
   }
   else
   {
      //printf("dia_KdsMapParser : parseLine - 10 \n\n");
      DIA_TR_INF("dia_KdsMapParser::parseLine - 10");
      DIA_TR_INF("Line is Empty");
   }
   DIA_TR_INF("dia_KdsMapParser::parseLine - 11");

   return retCode;
}
