/**
 * \file      dia_DsMapParser.h
 *
 * \brief     {Config update}
 *
 * \details   {Config update : DataSet}
 *
 * \author    nbs3kor
 * \date      Nov 10, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef __INCLUDED_DIA_DS_MAP_PARSER__
#define __INCLUDED_DIA_DS_MAP_PARSER__

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_LINE_PARSER__
#include "dia_LineParser.h"
#endif

using namespace dia_nsUtilities;

class dia_DsMapParser : public dia_LineParser
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_DsMapParser);

public:
   //! class constructor
   dia_DsMapParser ( void );
   //! class destructor
   virtual ~dia_DsMapParser ( void );

   //! parse the given line and extract the contents like - key, length and data bytes
   virtual tDiaResult parseLine ( const tChar *line, tU32 u32LineSize );
};

#endif /* __INCLUDED_DIA_DS_MAP_PARSER__ */
