/**
 * \file      dia_DsMapParser.cpp
 *
 * \brief     {Config update}
 *
 * \details   {Config update : DataSet}
 *
 * \author    nbs3kor
 * \date      Nov 10, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_DS_MAP_PARSER__
#include "dia_DsMapParser.h"
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_CONFIG__
#include "common/framework/datadownload/dia_DataDownloadConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

//-----------------------------------------------------------------------------

dia_DsMapParser::dia_DsMapParser ( void )
{
   dia_tclFnctTrace trc("dia_DsMapParser::dia_DsMapParser");
}

//-----------------------------------------------------------------------------

dia_DsMapParser::~dia_DsMapParser ( void )
{
   //dia_tclFnctTrace trc("dia_DsMapParser::~dia_DsMapParser");
   //DIA_TR_INF("dia_DsMapParser::~dia_DsMapParser");
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DsMapParser::parseLine ( const tChar *line, tU32 u32LineSize )
{
   dia_tclFnctTrace trc("dia_DsMapParser::parseLine");

   DIA_TR_INF("dia_DsMapParser::parseLine entry");

   tDiaResult retCode = DIA_FAILED;

   if ( u32LineSize != 0 )
   {
      //extract the required characters viz.

      DIA_TR_INF("dia_DsMapParser::parseLine - 1");

      tChar DSArrayElement [3];
      memset(DSArrayElement,'\0',3);
      tU32 u32dsHexElement = 0;
      tU32 u32iterationCountTwo = 0;

      tU8 u8dsElementByte = 0;

      tU8  au8dsDataBuffer[DIA_PROP_LENGTH_MAX] = { 0 };
      (tVoid) ::memset(au8dsDataBuffer, 0, DIA_PROP_LENGTH_MAX);

      for( tU32 u32iterationCountOne = 0; u32iterationCountOne < u32LineSize; u32iterationCountOne+=3)
      {
         DIA_TR_INF("dia_DsMapParser::parseLine - 2");
         (tVoid) OSAL_szStringNCopy (&(DSArrayElement[0]), &(line[u32iterationCountOne]), 2);
         DSArrayElement[2] = '\0';

         sscanf( DSArrayElement, "%x", (tS32*) (&u32dsHexElement) );
         au8dsDataBuffer[u32iterationCountTwo] = (tU8)u32dsHexElement;
         u8dsElementByte = au8dsDataBuffer[u32iterationCountTwo];
         u32iterationCountTwo = u32iterationCountTwo + 1;
         DIA_TR_INF("dia_DsMapParser::parseLine - Data (%d) : au8dsDataBuffer 0x%02x OR %d", (u32iterationCountTwo), u8dsElementByte, u8dsElementByte);
      }

     DIA_TR_INF("dia_DsMapParser::parseLine - 3");

     tU8 u8DSIdentifier1 = tU8(au8dsDataBuffer[0]);
     tU8 u8DSIdentifier2 = tU8(au8dsDataBuffer[1]);
      tU32 u32DSAddress   = U8_2_U32( 0x0, au8dsDataBuffer[2], au8dsDataBuffer[3], au8dsDataBuffer[4]);
      tU32 u32DS_Size     = U8_2_U32( 0x0, au8dsDataBuffer[5], au8dsDataBuffer[6], au8dsDataBuffer[7]);

      DIA_TR_INF("dia_DsMapParser::parseLine - u8DSIdentifier1 0x%04x OR %d", u8DSIdentifier1, u8DSIdentifier1);
     DIA_TR_INF("dia_DsMapParser::parseLine - u8DSIdentifier2 0x%04x OR %d", u8DSIdentifier2, u8DSIdentifier2);
      DIA_TR_INF("dia_DsMapParser::parseLine - u32DSAddress 0x%04x OR %d", u32DSAddress, u32DSAddress);
     DIA_TR_INF("dia_DsMapParser::parseLine - u32DS_Size 0x%04x OR %d", u32DS_Size, u32DS_Size);
      DIA_TR_INF("dia_DsMapParser::parseLine - u32iterationCountTwo %d", u32iterationCountTwo);

      if ( (u32DS_Size != 0x00) && (u32DS_Size == (u32iterationCountTwo - 8)) )
      {
         DIA_TR_INF("dia_DsMapParser::parseLine - 4");

       tU32 u32PropID = DIA_PROP_INVALID_IDENTIFIER;

       for(size_t u8iteratorDiaDatasetConfig = 0; u8iteratorDiaDatasetConfig < dia::getDiaDatasetPropDataSize(); ++u8iteratorDiaDatasetConfig)
       {
          DIA_TR_INF("dia_DsMapParser::parseLine - 5");
          DIA_TR_INF("dia_DsMapParser::parseLine - u8iteratorDiaDatasetConfig %zu", u8iteratorDiaDatasetConfig);
          if(u32DSAddress == aDiaDatasetConfig[u8iteratorDiaDatasetConfig].mAddrStart)
          {
             DIA_TR_INF("dia_DsMapParser::parseLine - 6");
             u32PropID = aDiaDatasetConfig[u8iteratorDiaDatasetConfig].mPropID;
             DIA_TR_INF("dia_DsMapParser::parseLine - Address %d and u32PropID %d", u32DSAddress, u32PropID);
             break;
          }
       }

       DIA_TR_INF("dia_DsMapParser::parseLine - 7");

       if(DIA_PROP_INVALID_IDENTIFIER != u32PropID)
       {
          DIA_TR_INF("dia_DsMapParser::parseLine - 8");
          DIA_TR_INF("dia_DsMapParser::parseLine - Try Write Data into DP entry 0x%04x with length %d", u32DSAddress, u32DS_Size);

          if( dia_setProperty(u32PropID, (&(au8dsDataBuffer[8])), (tU16) u32DS_Size) == DIA_SUCCESS )
          {
             DIA_TR_INF("dia_DsMapParser::parseLine - 9");
             DIA_TR_INF("dia_DsMapParser::parseLine - 10");
                 DIA_TR_INF("dia_DsMapParser::parseLine: Write Data into DP SUCCESSFUL");
                 retCode = DIA_SUCCESS;
          }
          else
          {
             DIA_TR_INF("dia_DsMapParser::parseLine - 11");
                 DIA_TR_INF("dia_DsMapParser::parseLine: Write Data into DP FAIL");
          }
       }
       else
       {
          DIA_TR_INF("dia_DsMapParser::parseLine - 12");
             DIA_TR_INF("dia_DsMapParser::parseLine - DIA_PROP_INVALID_IDENTIFIER");
       }
      }
      else
      {
          DIA_TR_INF("dia_DsMapParser::parseLine - 13");
          DIA_TR_INF("dia_DsMapParser::parseLine :- No data bytes to write to KDS OR no. of bytes not matching kds size byte");
      }
   }
   else
   {
      DIA_TR_INF("dia_DsMapParser::parseLine - 14");
      DIA_TR_INF("Line is Empty");
   }
   DIA_TR_INF("dia_DsMapParser::parseLine - 15");

   return retCode;
}
