/*
 * udd_types.h
 *
 *  Created on: 31.03.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_UDD_TYPES__
#define __INCLUDED_DIA_UDD_TYPES__

//namespace udd
//{

typedef tU32 udd_UID;

enum udd_eCommChannelType
{
    enCCTYPE_UNKNOWN = 0,
    enCCTYPE_CAN,
    enCCTYPE_LIN,
    enCCTYPE_MOST,
    enCCTYPE_FLEXRAY,
    enCCTYPE_USB,
    enCCTYPE_TCPIP,
    enCCTYPE_BLUETOOTH,
    enCCTYPE_RS232,
    enCCTYPE_COUNT
};

enum udd_eCommProtocol
{
    enCPROT_UNKNOWN = 0,
    enCPROT_UDS,
    enCPROT_MCNET,
    enCPROT_GMLAN,
    enCPROT_COUNT
};

//enum eCommDataType
//{
//    enCDTYPE_UNKNOWN = 0,
//    enCDTYPE_CTRL_EVENT,
//    enCDTYPE_CTRL_REQUEST,
//    enCDTYPE_CTRL_RESPONSE,
//    enCDTYPE_DATA_EVENT,
//    enCDTYPE_DATA_REQUEST,
//    enCDTYPE_DATA_RESPONSE,
//    enCDTYPE_COUNT
//};

enum udd_eCommParamType
{
    enCPT_UNKNOWN = 0,
    enCPT_BOOL,
    enCPT_U8,
    enCPT_U16,
    enCPT_U32,
    enCPT_STR,
    enCPT_COUNT
};

//} // end of namespace

#define UDD_C_U8_CHANNEL_UNKNOWN                ((tU8) 0x00)
#define UDD_C_U8_CHANNEL_CAN                    ((tU8) 0x01)
#define UDD_C_U8_CHANNEL_LIN                    ((tU8) 0x02)
#define UDD_C_U8_CHANNEL_MOST                   ((tU8) 0x03)
#define UDD_C_U8_CHANNEL_FLEXRAY                ((tU8) 0x04)
#define UDD_C_U8_CHANNEL_USB                    ((tU8) 0x05)
#define UDD_C_U8_CHANNEL_ETHERNET               ((tU8) 0x06)
#define UDD_C_U8_CHANNEL_BLUETOOTH              ((tU8) 0x07)
#define UDD_C_U8_CHANNEL_RS232                  ((tU8) 0x08)

#define UDD_C_U8_PROTOCOL_UNKNOWN               ((tU8) 0x00)
#define UDD_C_U8_PROTOCOL_UDS                   ((tU8) 0x01)
#define UDD_C_U8_PROTOCOL_MCNET                 ((tU8) 0x02)

#define UDD_C_U8_OPCODE_UNKNOWN                 ((tU8) 0x00)
#define UDD_C_U8_OPCODE_CONTROL                 ((tU8) 0x01) // internal request
#define UDD_C_U8_OPCODE_REQUEST                 ((tU8) 0x02) // external request
#define UDD_C_U8_OPCODE_RESPONSE                ((tU8) 0x03) // external response
#define UDD_C_U8_OPCODE_RESPONSE_ON_EVENT       ((tU8) 0x04) // external response on event
#define UDD_C_U8_OPCODE_STATUS                  ((tU8) 0x05) // internal status
#define UDD_C_U8_OPCODE_CONFIRMATION            ((tU8) 0x06) // confirmation after a message was sent to external tester
#define UDD_C_U8_OPCODE_ERROR                   ((tU8) 0x07)
#define UDD_C_U8_OPCODE_REGISTRATION            ((tU8) 0x08)
#define UDD_C_U8_OPCODE_REGISTRATION_STATUS     ((tU8) 0x09)
#define UDD_C_U8_OPCODE_DEREGISTRATION          ((tU8) 0x0A)
#define UDD_C_U8_OPCODE_DEREGISTRATION_STATUS   ((tU8) 0x0B)

#define UDD_C_U16_MSG_UNKNOWN                   ((tU16) 0x0000)
#define UDD_C_U16_MSG_CONTROL                   ((tU16) 0x0001)
#define UDD_C_U16_MSG_REQUEST                   ((tU16) 0x0002)
#define UDD_C_U16_MSG_RESPONSE                  ((tU16) 0x0003)
#define UDD_C_U16_MSG_TESTER_DISCONNECTED       ((tU16) 0x0004)
#define UDD_C_U16_MSG_BUS_RELEASED              ((tU16) 0x0005)
#define UDD_C_U16_MSG_IGNITION                  ((tU16) 0x0006)

#endif /* __INCLUDED_DIA_UDD_TYPES__ */
