/*
 * udd_DriverFacade.h
 *
 *  Created on: 04.04.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_UDD_DRIVER_FACADE__
#define __INCLUDED_DIA_UDD_DRIVER_FACADE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_UDD__
#include "udd.h"
#endif

//namespace udd
//{

class udd_CommChannel;

/**
 *
 *  \class udd::udd_DriverFacade
 *
 *  \brief single entrypoint to the Unified Diagnosis Driver framework
 *
 *  \ingroup diagFramework
 */

class udd_DriverFacade
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(udd_DriverFacade);

public:
    //! assign a certain channel to the facade
    tDiaResult assign ( udd_CommChannel& channel );

    //! query for a certain channel
    tDiaResult queryCommChannel ( udd_UID uid, udd_CommChannel** pChannel );

    //! connect to the specified channel
    tDiaResult connect ( udd_UID uid );

protected:
    //! default constructor
    udd_DriverFacade ( void );
    //! destructor
    virtual ~udd_DriverFacade ( void );

protected:
    //! repository of available communication channels
    std::map<udd_UID,udd_CommChannel*> mChannelRep;
};

//}

udd_DriverFacade* getInstanceOfFacadeUDD ( void );
void releaseInstanceOfFacadeUDD ( void );

#endif /* __INCLUDED_DIA_UDD_DRIVER_FACADE__ */
