/*
 * udd_CommChannelConfig.h
 *
 *  Created on: 06.09.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_UDD_COMMUNICATION_CHANNEL_CONFIGURATION__
#define __INCLUDED_UDD_COMMUNICATION_CHANNEL_CONFIGURATION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#define UDD_CHANNEL_EXT_CONFIG_ELEM_MAX                           ((tU16) 20)

//#############################################################################
//#
//# A unique range for project specific channel IDs is reserved
//#
//#############################################################################

// start addresses of known channel ranges
#define UDD_CHANNEL_RANGE_START_COMMON                            ((tU32) 0x00000000)
#define UDD_CHANNEL_RANGE_START_VAG                               ((tU32) 0x00100000)
#define UDD_CHANNEL_RANGE_START_NISSAN                            ((tU32) 0x00200000)
#define UDD_CHANNEL_RANGE_START_FORD                              ((tU32) 0x00400000)
#define UDD_CHANNEL_RANGE_START_GM                                ((tU32) 0x00800000)
#define UDD_CHANNEL_RANGE_START_PSA                               ((tU32) 0x01000000)
#define UDD_CHANNEL_RANGE_START_SUZUKI                            ((tU32) 0x01200000)
#define UDD_CHANNEL_RANGE_START_JAC                               ((tU32) 0x01400000)

// the following macros might be used to assign property IDs to a certain range
#define UDD_CHANNEL_COMMON(cid)                                   (((tU32) (cid)) | UDD_CHANNEL_RANGE_START_COMMON)
#define UDD_CHANNEL_VAG(cid)                                      (((tU32) (cid)) | UDD_CHANNEL_RANGE_START_VAG)
#define UDD_CHANNEL_NISSAN(cid)                                   (((tU32) (cid)) | UDD_CHANNEL_RANGE_START_NISSAN)
#define UDD_CHANNEL_FORD(cid)                                     (((tU32) (cid)) | UDD_CHANNEL_RANGE_START_FORD)
#define UDD_CHANNEL_GM(cid)                                       (((tU32) (cid)) | UDD_CHANNEL_RANGE_START_GM)
#define UDD_CHANNEL_PSA(cid)                                      (((tU32) (cid)) | UDD_CHANNEL_RANGE_START_PSA)
#define UDD_CHANNEL_SUZUKI(cid)                                   (((tU32) (cid)) | UDD_CHANNEL_RANGE_START_SUZUKI)
#define UDD_CHANNEL_JAC(cid)                                      (((tU32) (cid)) | UDD_CHANNEL_RANGE_START_JAC)

//#############################################################################
//#
//# Common Property Key Definitions
//#
//#############################################################################

#define UDD_CHANNEL_UID_UNKNOWN                                   ((tU32) 0xFFFFFFFF)

#define UDD_CHANNEL_UID_UDS_CAN                                   UDD_CHANNEL_COMMON(((tU32) 0x00000001))
#define UDD_CHANNEL_UID_UDS_RUN_IN                                UDD_CHANNEL_COMMON(((tU32) 0x00000002))
#define UDD_CHANNEL_UID_UDS_BURN_IN                               UDD_CHANNEL_COMMON(((tU32) 0x00000003))
#define UDD_CHANNEL_UID_UDS_LIN                                   UDD_CHANNEL_COMMON(((tU32) 0x00000004))
#define UDD_CHANNEL_UID_UDS_TCPIP                                 UDD_CHANNEL_COMMON(((tU32) 0x00000005))
#define UDD_CHANNEL_UID_UDS_DOIP                                  UDD_CHANNEL_COMMON(((tU32) 0x00000006))

#define UDD_CHANNEL_UID_GMLAN_CAN                                     UDD_CHANNEL_GM(((tU32) 0x00000001))

// LAST: 0x00000003

//--- physical layer types ----------------------------------------------------

enum udd_enChannelPhysicalLayer
{
    UDD_CHANNEL_PHYSICAL_LAYER_UNKNOWN = 0,
    UDD_CHANNEL_PHYSICAL_LAYER_BLUETOOTH,
    UDD_CHANNEL_PHYSICAL_LAYER_CAN,
    UDD_CHANNEL_PHYSICAL_LAYER_ETHERNET,
    UDD_CHANNEL_PHYSICAL_LAYER_FLEXRAY,
    UDD_CHANNEL_PHYSICAL_LAYER_LIN,
    UDD_CHANNEL_PHYSICAL_LAYER_LOCAL,
    UDD_CHANNEL_PHYSICAL_LAYER_RS232,
    UDD_CHANNEL_PHYSICAL_LAYER_SPI,
    UDD_CHANNEL_PHYSICAL_LAYER_USB,
    UDD_CHANNEL_PHYSICAL_LAYER_COUNT
};

//--- protocol types ----------------------------------------------------------

enum udd_enChannelProtocol
{
    UDD_CHANNEL_PROTOCOL_UNKNOWN = 0,
    UDD_CHANNEL_PROTOCOL_UDS,
    UDD_CHANNEL_PROTOCOL_GMLAN,
    UDD_CHANNEL_PROTOCOL_COUNT
};

struct udd_ChannelInfo
{
   //! unique identifier of the UDD channel
   tU32 mUID;
   //! LUN (logical unit identifier) to refer to sub channel
   tU32 mLUN;
   //! physical layer used by the UDD channel
   udd_enChannelPhysicalLayer mPhysicalLayer;
   //! protocol used on the UDD channel
   udd_enChannelProtocol mProtocol;
   //! control flags for the UDD channel
   tU32 mControlFlags;
   //! data field for additional configuration
   tU32 mChannelExtData[UDD_CHANNEL_EXT_CONFIG_ELEM_MAX];
};

#define UDD_CHANNEL_FLAG_RX_ENABLE     ((tU32) 0x00000001)
#define UDD_CHANNEL_FLAG_RXTX_ENABLE   ((tU32) 0x00000003)
#define UDD_CHANNEL_FLAG_TX_ENABLE     ((tU32) 0x00000002)

//#############################################################################
//#
//# Detailed descriptions of common properties
//#
//#############################################################################

const udd_ChannelInfo
aCommonChannelData[] =
{
   // channel UID                   // LUN   // phys. layer                      // protocol                   // flags                         // extended data field
   { UDD_CHANNEL_UID_UDS_CAN,       0,       UDD_CHANNEL_PHYSICAL_LAYER_CAN,     UDD_CHANNEL_PROTOCOL_UDS,     UDD_CHANNEL_FLAG_RX_ENABLE,      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { UDD_CHANNEL_UID_UDS_LIN,       0,       UDD_CHANNEL_PHYSICAL_LAYER_LIN,     UDD_CHANNEL_PROTOCOL_UNKNOWN, UDD_CHANNEL_FLAG_RX_ENABLE,      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { UDD_CHANNEL_UID_UDS_RUN_IN,    0,       UDD_CHANNEL_PHYSICAL_LAYER_LOCAL,   UDD_CHANNEL_PROTOCOL_UDS,     UDD_CHANNEL_FLAG_RXTX_ENABLE,    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} },
   { UDD_CHANNEL_UID_GMLAN_CAN,     0,       UDD_CHANNEL_PHYSICAL_LAYER_CAN,     UDD_CHANNEL_PROTOCOL_GMLAN,   UDD_CHANNEL_FLAG_RX_ENABLE,      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0} }
};

#endif /* __INCLUDED_UDD_COMMUNICATION_CHANNEL_CONFIGURATION__ */
