/*!
 * \file       dia_defsINC.h
 *
 * \brief      Defines for INC Communication Channel
 *
 * \details    Defines for INC Communication Channel
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreUDD
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_DEFS_INC__
#define __INCLUDED_DIA_DEFS_INC__

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// component status
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// PDU IDs
#define SCC_DIAGNOSIS_C_COMPONENT_STATUS                          ((tU8)  0x20)
#define SCC_DIAGNOSIS_R_COMPONENT_STATUS                          ((tU8)  0x21)

#define SCC_DIAGNOSIS_COMPONENT_STATUS_MSGLEN                     ((tU16)    4)
#define SCC_DIAGNOSIS_COMPONENT_STATUS_IDX_STATUS                 ((tU8)     1)
#define SCC_DIAGNOSIS_COMPONENT_STATUS_IDX_MAJOR_VERSION          ((tU8)     2)
#define SCC_DIAGNOSIS_COMPONENT_STATUS_IDX_MINOR_VERSION          ((tU8)     3)
#define SCC_DIAGNOSIS_COMPONENT_STATUS_UNKNOWN                    ((tU8)  0x00)
#define SCC_DIAGNOSIS_COMPONENT_STATUS_ACTIVE                     ((tU8)  0x01)
#define SCC_DIAGNOSIS_COMPONENT_STATUS_INACTIVE                   ((tU8)  0x02)
#define SCC_DIAGNOSIS_COMPONENT_STATUS_MAJOR_VERSION              ((tU8)  0x01)
#define SCC_DIAGNOSIS_COMPONENT_STATUS_MINOR_VERSION              ((tU8)  0x00)

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// state update
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// PDU IDs
#define SCC_DIAGNOSIS_C_STATE_UPDATE                              ((tU8)  0x34)
#define SCC_DIAGNOSIS_R_STATE_UPDATE                              ((tU8)  0x35)

#define SCC_DIAGNOSIS_C_POST_PROCESSING_REQUEST                   ((tU8)  0x36)
#define SCC_DIAGNOSIS_R_POST_PROCESSING_REQUEST                   ((tU8)  0x37)
#define SCC_DIAGNOSIS_C_POST_PROCESSING_REQUEST_MSGLEN            ((tU8)    11)

#define SCC_DIAGNOSIS_C_STATE_UPDATE_MSGLEN                       ((tU8)     7)
#define SCC_DIAGNOSIS_C_STATE_UPDATE_IDX_SESSION_ID               ((tU8)     2)
#define SCC_DIAGNOSIS_C_STATE_UPDATE_IDX_BITMASK_1                ((tU8)     3)
#define SCC_DIAGNOSIS_C_STATE_UPDATE_IDX_BITMASK_2                ((tU8)     4)
#define SCC_DIAGNOSIS_C_STATE_UPDATE_IDX_BITMASK_3                ((tU8)     5)
#define SCC_DIAGNOSIS_C_STATE_UPDATE_IDX_BITMASK_4                ((tU8)     6)

#define SCC_DIAGNOSIS_C_STATE_UPDATE_TESTER_PRESENT_BITMASK       ((tU32) 0x80000000)
#define SCC_DIAGNOSIS_C_STATE_UPDATE_INITIAL_BITMASK              ((tU32) 0xFFFFFFFF)
#define SCC_DIAGNOSIS_C_STATE_UPDATE_OPMODE_STATUSMASK            ((tU32) 0x00780000)

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// force state change
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// PDU IDs
#define SCC_DIAGNOSIS_C_FORCE_STATE_CHANGE                        ((tU8)  0x46)
#define SCC_DIAGNOSIS_R_FORCE_STATE_CHANGE                        ((tU8)  0x47)

#define SCC_DIAGNOSIS_C_FORCE_STATE_CHANGE_MSGLEN                 ((tU8)     7)
#define SCC_DIAGNOSIS_C_FORCE_STATE_CHANGE_IDX_SESSION_ID         ((tU8)     2)
#define SCC_DIAGNOSIS_C_FORCE_STATE_CHANGE_IDX_BITMASK_1          ((tU8)     3)
#define SCC_DIAGNOSIS_C_FORCE_STATE_CHANGE_IDX_BITMASK_2          ((tU8)     4)
#define SCC_DIAGNOSIS_C_FORCE_STATE_CHANGE_IDX_BITMASK_3          ((tU8)     5)
#define SCC_DIAGNOSIS_C_FORCE_STATE_CHANGE_IDX_BITMASK_4          ((tU8)     6)

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// diagnosis request
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// PDU IDs
#define SCC_DIAGNOSIS_C_REQUEST                                   ((tU8)  0x30)
#define SCC_DIAGNOSIS_R_REQUEST                                   ((tU8)  0x31)

#define SCC_DIAGNOSIS_C_REQUEST_MSGLEN_MIN                        ((tU8)     2)

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// diagnosis response
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// PDU IDs
#define SCC_DIAGNOSIS_C_DIAG_RESPONSE                             ((tU8)  0x32)
#define SCC_DIAGNOSIS_R_DIAG_RESPONSE                             ((tU8)  0x33)

#define SCC_DIAGNOSIS_R_DIAG_RESPONSE_MSGLEN                      ((tU16)    2)
#define SCC_DIAGNOSIS_DIAG_RESPONSE_IDX_TP_MARKER                 ((tU8)     0)
#define SCC_DIAGNOSIS_DIAG_RESPONSE_TP_MARKER                     ((tU8)  0x00)

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define SCC_DIAGNOSIS_C_MIN_MSGLEN                                ((tU16) 2)
#define SCC_DIAGNOSIS_CONFIRMATION_MSGLEN                         ((tU16) 2)

#define SCC_DIAGMSG_IDX_MSG_ID                                    ((tU16) 0)
#define SCC_DIAGMSG_IDX_CHANNEL_ID                                ((tU16) 1)

#define DIA_REMOVE_SECURITY_LEVEL_BITMASK                         ((tU32) 0x807FFFFF) // = 1000 0000 0111 1111 1111 1111 1111 1111, remove Bit 1 - 8 = Project specific Security Levels
#define DIA_SECURITY_LEVEL_NUMBER_LEFT_SHIFT                      23 // security level from property is shifted by 23 to left, so as to be added into state bitmask

#define DIA_C_U8_INVALID_CHANNEL_ID                               ((tU8) 0xFF)

#define DIA_C_U16_INC_DEFAULT_MSG_SIZE                            ((tU16) 4100) // Need space for INC header + max. 4095 bytes via ISOTP

#endif /* __INCLUDED_DIA_DEFS_INC__ */
