/**
 * \file      dia_TracePluginUDS.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      14.06.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#include "dia_TracePluginUDS.h"

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include "common/framework/protocols/uds/dia_MessageBufferUDS.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include <common/framework/utils/dia_utilities.h>
#endif

#define DIA_C_TTFIS_PAYLOAD_START_POS     3

dia_TracePluginUDS::dia_TracePluginUDS ( tVoid )
   :  dia_TracePlugin(ID_DIA_REQ, PAR_DIA_UDS)
{}

//-----------------------------------------------------------------------------

dia_TracePluginUDS::~dia_TracePluginUDS ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_TracePluginUDS::onTraceMessage ( tU8* pMessage )
{
   dia_tclFnctTrace oTrace("dia_TracePluginUDS::onTraceMessage");

   // number of following bytes
   tU16 length   =  pMessage[0];
   tU8* pPayLoad = &pMessage[DIA_C_TTFIS_PAYLOAD_START_POS];

   DIA_TR_INF("--- Got an UDS Msg");

   // create an object containing the UDS msg buffer
   dia_MessageBufferUDS* poMsgBuffer = OSAL_NEW dia_MessageBufferUDS(pPayLoad, tU16(length-2), vSendResponseToTrace); //lint !e429: custodial pointer is freed by after engine has processed the message

   DIA_TR_SM("UDS msg RX via TTFis: Length: %d Data: %s", length-2, dia::utils::bin2str(pPayLoad,length-2,' ').c_str());

   if ( poMsgBuffer && (handleMessage(*poMsgBuffer) == DIA_E_NOT_AVAILABLE) )
   {
      // create and send event ReqRx containing a ptr to the reqest msg buffer
      dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventReqRx(poMsgBuffer)); //lint !e429: custodial pointer is freed by after engine has processed the message
   }

   // make lint happy
   poMsgBuffer = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'poMsgBuffer'. --> lifetime is controlled by diagnostic session

   return DIA_SUCCESS; //lint !e438 Warning: last value assigned to variable 'poMsgBuffer' not used
}

//-----------------------------------------------------------------------------

void
dia_TracePluginUDS::vSendResponseToTrace ( const tU8 au8MsgBuffer[], tU16 u16Length, tCookieType /*ccokie*/ )
{
   dia_tclFnctTrace oTrace("dia_TracePluginUDS::vSendResponseToTrace");
   const tU16 DIA_C_TTFIS_PAYLOAD = 192;
   const tU16 MAX_BYTE = 64;
   size_t payloadLength = 0;
   tU16 count = 0;

   // send response msg to TTFis
   std::string rstr = dia::utils::bin2str(au8MsgBuffer,u16Length,' ');
   payloadLength = rstr.length();
   tU16 maxCount = (tU16) (payloadLength/DIA_C_TTFIS_PAYLOAD);

   DIA_TR_SM("UDS msg TX via TTFis: Length: %d Data: %s", u16Length, rstr.substr(0, DIA_C_TTFIS_PAYLOAD).c_str());

   for(count = 1; count <= maxCount ; ++count)
   {
      DIA_TR_SM("Data[%d-%d]: %s", (MAX_BYTE*count), (MAX_BYTE*(count+1))-1, rstr.substr(DIA_C_TTFIS_PAYLOAD*count, DIA_C_TTFIS_PAYLOAD).c_str());
   }

   dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventConfTxOk()); //lint !e429: custodial pointer is freed by after engine has processed the message
}

