/**
 * \file      dia_TracePluginGMLan.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      14.06.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#include "dia_TracePluginGMLan.h"

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include <common/framework/protocols/gmlan/dia_MessageBufferGMLan.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_BASE
#include "trcGenProj/Header/dia_TracePluginGMLan.cpp.trc.h"
#endif

#define DIA_C_TTFIS_PAYLOAD_START_POS     3

dia_TracePluginGMLan::dia_TracePluginGMLan ( tVoid )
   :  dia_TracePlugin(ID_DIA_REQ, PAR_DIA_GMLAN)
{}

//-----------------------------------------------------------------------------

dia_TracePluginGMLan::~dia_TracePluginGMLan ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_TracePluginGMLan::onTraceMessage ( tU8* pMessage )
{
   dia_tclFnctTrace oTrace("dia_TracePluginGMLan::onTraceMessage");

   // number of following bytes
   tU16 length   =  pMessage[0];
   tU8* pPayLoad = &pMessage[DIA_C_TTFIS_PAYLOAD_START_POS];

   DIA_TR_INF("--- Got an GMLAN Msg");

   // create an object containing the UDS msg buffer
   dia_MessageBufferGMLan* poMsgBuffer = OSAL_NEW dia_MessageBufferGMLan(pPayLoad, tU16(length-2), vSendResponseToTrace); //lint !e429: custodial pointer is freed by after engine has processed the message

   //ETG_TRACE_COMP_CLS((TR_CLASS_DIAGNOSTICS_SM, "GMLAN msg RX via TTFis: Length: %d Data: %02x", length-2, ETG_LIST(length-2, ETG_T8, pPayLoad)));

   // create and send event ReqRx containing a ptr to the reqest msg buffer
   dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventReqRx(poMsgBuffer)); //lint !e429: custodial pointer is freed by after engine has processed the message

   // make lint happy
   poMsgBuffer = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'poMsgBuffer'. --> lifetime is controlled by diagnostic session

   return DIA_SUCCESS; //lint !e438 Warning: last value assigned to variable 'poMsgBuffer' not used
}

//-----------------------------------------------------------------------------

void
dia_TracePluginGMLan::vSendResponseToTrace ( const tU8 au8MsgBuffer[], tU16 u16Length, tCookieType /*cookie*/ )
{
   dia_tclFnctTrace oTrace("dia_TracePluginGMLan::vSendResponseToTrace");

   // send response msg to TTFis
//   ETG_TRACE_COMP_CLS((TR_CLASS_DIAGNOSTICS_SM, "GMLAN msg TX via TTFis: Length: %d Data: %02x", u16Length, ETG_LIST(u16Length, ETG_T8, au8MsgBuffer)));

   dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventConfTxOk()); //lint !e429: custodial pointer is freed by after engine has processed the message
}

