/**
 * \file      dia_TracePluginCMD.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      14.06.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef DIA_TRACECMDFACTORY_H_
#include "common/framework/trace/dia_TraceCmdFactory.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include <common/framework/utils/dia_utilities.h>
#endif

#include "dia_TracePluginCMD.h"

//#define DIA_C_TTFIS_TRACE_CMD_POS         1
//#define DIA_C_TTFIS_TRACE_SUBCMD_POS      2
#define DIA_C_TTFIS_PAYLOAD_START_POS     3

dia_TraceCmdFactory* dia_TraceCmdFactory::s_pTraceCommandFactoryProject = NULL; // definition of pointer member variable used to access the project specific Trace Command Factory

//-----------------------------------------------------------------------------

dia_TracePluginCMD::dia_TracePluginCMD(tVoid)
   : dia_TracePlugin(ID_DIA_REQ, PAR_DIA_CMD)
{}

//-----------------------------------------------------------------------------

dia_TracePluginCMD::~dia_TracePluginCMD(tVoid)
{
}

tDiaResult
dia_TracePluginCMD::onTraceMessage(tU8* pMessage)
{
   dia_tclFnctTrace oTrace("dia_TracePluginCMD::onTraceMessage");

   // number of following bytes
   tU8 length =  pMessage[0];

   if ( length < 4 )
   {
      DIA_TR_INF("dia_TracePluginCMD::onTraceMessage ERROR: Wrong length of message = 0x%02x", length);
      return DIA_FAILED;
   }

   tU16 cmdID = static_cast<tU16>((pMessage[DIA_C_TTFIS_PAYLOAD_START_POS] << 8) | pMessage[DIA_C_TTFIS_PAYLOAD_START_POS + 1]);

   for (tU16 i=0; i<(tU16)length+1; i++)
   {
      DIA_TR_INF("TTFIS Command[%d]: 0x%02X", i, pMessage[i]);
   }

   DIA_TR_INF("TTFIS Command ID: 0x%04X", cmdID);

   std::map<tU16, dia_TraceCmd*>::iterator iter = mMapTraceCmd.find(cmdID);
   dia_TraceCmd* pdia_TraceCmd = NULL;

   if (iter != mMapTraceCmd.end())
   {
      DIA_TR_INF("dia_TracePluginCMD::onTraceMessage Found in map. cmdID = 0x%04x", cmdID);

      if (NULL != iter->second)
      {
         /* execute() later */
         pdia_TraceCmd = iter->second;

         if (NULL==pdia_TraceCmd)
         {
            DIA_TR_WRN("dia_TracePluginCMD::onTraceMessage Found in map, but object not created. cmdID=%d", cmdID);
         }
      }
      else
      {
         DIA_TR_ERR("dia_TracePluginCMD::onTraceMessage Null pointer for cmdID=%d", cmdID);
      }
   }

   // try to create an object
   if (NULL==pdia_TraceCmd)
   {
      DIA_TR_INF("dia_TracePluginCMD::onTraceMessage Try to create. cmdID = 0x%04x", cmdID);

      pdia_TraceCmd = dia_TraceCmdFactory::createTraceCmd(static_cast<dia_TraceCmdFactory::dia_enTraceCmdID>(cmdID));
      mMapTraceCmd[cmdID] = pdia_TraceCmd;
   }

   if (NULL!=pdia_TraceCmd)
   {
      pdia_TraceCmd->execute(pMessage);
   }
   else
   {
      DIA_TR_INF("dia_TracePluginCMD::onTraceMessage Object not created! cmdID = 0x%04x", cmdID);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_TracePluginCMD::vSendResponseToTrace(const tU8 au8MsgBuffer[], tU16 u16Length, void* /*cookie*/ )
{
   dia_tclFnctTrace oTrace("dia_TracePluginCMD::vSendResponseToTrace");

   // send response msg to TTFis
   DIA_TR_SM("Trace Cmd TX via TTFis: Length: %d Data: %s", u16Length, dia::utils::bin2str(au8MsgBuffer,u16Length,' ').c_str());
}
