/**
 * \file      dia_TracePlugin.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      14.06.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_TRACE_PLUGIN__
#define __INCLUDED_DIA_TRACE_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

class dia_TracePlugin
{
public:
   virtual tDiaResult onTraceMessage ( tU8* pMessage ) = 0;

   tU8 getID ( void ) const { return mClassID; }
   tU8 getParameter ( void ) const { return mParamID; }
   tU8 getFormat ( void ) const { return ((mParamID != PAR_DIA_NOT_AVAILABLE) ? 1 : 0); }

protected:
   dia_TracePlugin ( void );
   dia_TracePlugin ( tU8 classID, tU8 paramID ) : mClassID(classID), mParamID(paramID) {}
   virtual ~dia_TracePlugin ( void ) {}

protected:
   //! trace class identifier
   tU8 mClassID;
   //! trace command parameter
   tU8 mParamID;
};

#endif /* __INCLUDED_DIA_TRACE_PLUGIN__ */
