/**
 * \file      dia_TraceMonitor.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      14.06.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_TRACE_MONITOR__
#define __INCLUDED_DIA_TRACE_MONITOR__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TRACE_LISTENER__
#include "common/interfaces/dia_ITraceListener.h"
#endif

class dia_TracePlugin;
class dia_IDriver;

//-----------------------------------------------------------------------------

class dia_TraceMonitor
   : public dia_ITraceListener
{
public:
   //! class destructor
   dia_TraceMonitor ( void );
   //! class destructor
   dia_TraceMonitor ( dia_IDriver* traceDriver );
   //! class destructor
   virtual ~dia_TraceMonitor ( void );

   //! open the trace monitor
   tDiaResult open ( void ) const;
   //! close the trace monitor
   tDiaResult close ( void ) const;

   // add a new plugin to the trace monitor
   tDiaResult addTracePlugin ( dia_TracePlugin* pPlugin, tBool bDefaultPlugin=FALSE );
   // remove a plugin from the trace monitor
   tDiaResult removeTracePlugin ( const dia_TracePlugin* pPlugin );

   //! overloaded method from dia_ITraceListener that is called when a new trace message has been arrived
   virtual void vOnTraceMessage ( tU8* pMessage );

protected:
   //! pointer to the driver object
   dia_IDriver* mpDriverTrace;
   //! list of registered trace modules
   std::map<tU8,tU8> mPluginFormats;
   //! map of registered trace modules
   std::map<tU32,dia_TracePlugin*> mPluginRep;

   //! pointer to the default plugin, that is used if no other plugin was found
   dia_TracePlugin* mpDefaultPlugin;
};

#endif /* __INCLUDED_DIA_TRACE_MONITOR__ */
