/*
 * \file        dia_TraceCmdTesterDisappear.cpp
 *
 * \brief       Internal command for testing of CAN tester disappearance
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Sep 08, 2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 */

// DIA_REQ CMD 0 D
// DIA_CMD TESTER_DISAPPEAR


#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include "common/framework/engine/dia_ServiceDispatcher.h"
#endif

//#ifndef __INCLUDED_DIA_ENGINE_BODY__
//#include "common/framework/engine/dia_EngineBody.h"
//#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION__
#include "common/framework/engine/dia_EngineConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef DIA_TRACECMDTESTERDISAPPEAR_H_
#include "common/framework/trace/dia_TraceCmdTesterDisappear.h"
#endif


   // p = pMessage
   //              p0 p1 p2 p3 p4
   //                       |   |
   // (2 bytes) cmdID     --|-+-|

void dia_TraceCmdTesterDisappear::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdTesterDisappear::execute");

   if (4 != pMessage[0])
   {
      DIA_TR_ERR("dia_TraceCmdTesterDisappear::execute Incorrect message length. Length = 0x%02x", pMessage[0]);
      return;
   }

   dia_EngineServer* pEngine = 0;
   tDiaResult retVal = getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_PRODUCTION_UDS,&pEngine);

   if ((DIA_SUCCESS==retVal) && (NULL!=pEngine))
   {
      pEngine->getSessionController()->setSessionDefault();
   }
   else
   {
      if (DIA_SUCCESS!=retVal)   DIA_TR_INF("##### UNABLE TO RETRIEVE POINTER TO DIAGNOSIS ENGINE : queryEngine failed #####");
      else if (NULL==pEngine)    DIA_TR_INF("##### UNABLE TO RETRIEVE POINTER TO DIAGNOSIS ENGINE : pEngine NULL #####");
   }
}
