/*
 * dia_TraceCmdRunConfigUpdate.cpp
 *
 *  Created on: Jan 29, 2014
 *      Author: bhs1hi
 */

// DIA_REQ CMD 0 13

#ifndef __INCLUDED_DIA_UPDATE_MANAGER__
#include "common/framework/update/dia_UpdateManager.h"
#endif

#ifndef DIA_TRACECMDRUNCONFIGUPDATE_H_
#include "common/framework/trace/dia_TraceCmdRunConfigUpdate.h"
#endif

   // p = pMessage
   //              p0 p1 p2 p3 p4
   //                       |   |
   // (2 bytes) cmdID     --|-+-|
   //

void dia_TraceCmdRunConfigUpdate::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdRunConfigUpdate::execute");

   if ( pMessage[0] != 4)
   {
      DIA_TR_ERR("dia_TraceCmdRunConfigUpdate::execute Incorrect message length. Length = 0x%02x",pMessage[0]);
      return;
   }

   // get the pointer to the update manager
   dia_UpdateManager* pUpdateMgr = getInstanceOfUpdateManager();
   if ( !pUpdateMgr )
   {
      DIA_TR_ERR(("dia_TraceCmdRunConfigUpdate::execute(DIA_EN_INITLEVEL_4) - creation of update manager failed !!"));
   }
   else
   {
      (void) pUpdateMgr->runUpdate();
   }
}
