/*
 * dia_TraceCmdPropertyBagSet.cpp
 *
 *  Created on: Dec 19, 2013
 *      Author: kaa1hi
 */

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef DIA_TRACECMDPROPERTYBAGSET_H_
#include "common/framework/trace/dia_TraceCmdPropertyBagSet.h"
#endif

#ifndef __INCLUDED_DIA_TRACE_PLUGIN__
#include "common/framework/trace/dia_TracePluginCMD.h"
#endif

void dia_TraceCmdPropertyBagSet::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdPropertyBagSet::execute writePropertyIntoMemory");

   if ( pMessage[0] < 10)
   {
      DIA_TR_ERR("dia_TraceCmdPropertyBagSet::execute Message too short. Length = 0x%02x",pMessage[0]);
      return;
   }

   tU32 retCode = DIA_FAILED;

   tU32 propID = U8_2_U32(pMessage[5], pMessage[6], pMessage[7], pMessage[8]);
   DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute propID = 0x%04x .",pMessage[8]);

   // data memory
   tU8 propValueString[DIA_PROP_LENGTH_MAX_REG - CMD_HEAD_LENGTH] = {0};
   tU8 currValueString[DIA_PROP_LENGTH_MAX_REG] = {0};
   // initialize the data memory
   (tVoid) ::memset(propValueString, 0, DIA_PROP_LENGTH_MAX_REG - CMD_HEAD_LENGTH);
   (tVoid) ::memset(currValueString, 0, DIA_PROP_LENGTH_MAX_REG);

   tU8 inputLength = pMessage[9];
   DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute inputLength = %d .",inputLength);
   for(tU8 i=0; i<inputLength; i++){
      DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute propValueString[%d]=0x%02x .",i,pMessage[10+i]);
      propValueString[i] = pMessage[10+i];
   }

   auto propLength = dia_getPropertySize(propID);
   if((propLength >= inputLength) && (inputLength > 0))
   {
      // read current/old value
      retCode = dia_getProperty(propID, currValueString, &propLength);
      DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute start string = \"%s\" .",currValueString);
      DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute dia_getProperty -> propLength = %zu",propLength);
      if (retCode != DIA_SUCCESS) {
         DIA_TR_ERR("dia_TraceCmdPropertyBagSet::execute getProperty FAILED .");
      }
      // write new value to memory
      if(propLength < SIZE_MAX)
      {
         retCode = dia_setProperty(propID, propValueString, propLength);
         DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute set   string = \"%s\" .",propValueString);
         if (retCode == DIA_SUCCESS) {
            DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute setProperty SUCCESS .");
         } else {
            DIA_TR_ERR("dia_TraceCmdPropertyBagSet::execute setProperty FAILED .");
         }
      }
      else
      {
         retCode = DIA_FAILED;
         DIA_TR_ERR("dia_TraceCmdPropertyBagSet::execute Length of the property = %zu is not in valid range.",propLength);
      }
   }
   else
   {
      DIA_TR_ERR("dia_TraceCmdPropertyBagSet::execute LENGTH FAILURE. propperty length = %zu ; input length = %u .",propLength,inputLength);
   }

   if(retCode==DIA_SUCCESS)
   {
      DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute PROCEDURE SUCCESSFUL .");
      tU8 au8posRespString[DIA_PROP_LENGTH_MAX_REG] = { 0 };
      DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute input length=%d .",inputLength);
      for (tU8 i = 0; i < (CMD_HEAD_LENGTH + inputLength); i++) {
         au8posRespString[i] = pMessage[3+i];
         DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute au8posRespString[%d] = 0x%02x .",i,au8posRespString[i]);
      }
      dia_TracePluginCMD::vSendResponseToTrace(au8posRespString, tU16(CMD_HEAD_LENGTH + inputLength), 0 );
   }
   else
   {
      DIA_TR_INF("dia_TraceCmdPropertyBagSet::execute PROCEDURE FAILED !");
      tU8 au8negRespString[CMD_HEAD_LENGTH] = {pMessage[3], pMessage[4], pMessage[5], pMessage[6], pMessage[7], pMessage[8], 0x00};
      dia_TracePluginCMD::vSendResponseToTrace(au8negRespString, CMD_HEAD_LENGTH, 0);
   }
}
