/*
 * dia_TraceCmdPropertyBagGet.cpp
 *
 *  Created on: Dec 19, 2013
 *      Author: kaa1hi
 */
// DIA_REQ CMD 0 7            <== it doesn't work
// DIA_PROPERTY_BAG_GET AD    <== print whole content of property with ID=0x000000AD

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef DIA_TRACECMDPROPERTYBAGGET_H_
#include "common/framework/trace/dia_TraceCmdPropertyBagGet.h"
#endif

#ifndef __INCLUDED_DIA_TRACE_PLUGIN__
#include "common/framework/trace/dia_TracePluginCMD.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SM
#include "trcGenProj/Header/dia_TraceCmdPropertyBagGet.cpp.trc.h"
#endif

   // p = pMessage
   //              p0 p1 p2 p3 p4 p5  p6  p7  p8
   //                       |   |  |   |   |   |
   // (2 bytes) cmdID     --|-+-|  |   |   |   |
   // (4 bytes) prop ID         ---|-+-|-+-|-+-|

void dia_TraceCmdPropertyBagGet::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdPropertyBagGet::execute readPropertyFromMemory");

   if ( pMessage[0] != 8)
   {
      DIA_TR_ERR("dia_TraceCmdPropertyBagGet::execute Incorrect message length. Length = 0x%02x", pMessage[0]);
      return;
   }

   tU32 propID = U8_2_U32(pMessage[5], pMessage[6], pMessage[7], pMessage[8]);
   DIA_TR_INF("dia_TraceCmdPropertyBagGet::execute propID = 0x%08x", propID );
   std::vector<tU8> dataVec;
   if ( dia_getProperty(propID, dataVec) == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_TraceCmdPropertyBagGet::execute getProperty SUCCESS .");
   }
   else
   {
      DIA_TR_ERR("dia_TraceCmdPropertyBagGet::execute getProperty FAILED .");
      return;
   }

   /*lint -save -e864 Expression involving variable 'dataVec' possibly depends on order of evaluation */
   //ETG_TRACE_COMP_CLS((TR_CLASS_DIAGNOSTICS_SM, "Property[0x%08X] Length: %d Data Hex: %02x",
                       //propID, dataVec.size(), ETG_LIST((unsigned int)dataVec.size(), ETG_T8, const_cast<tU8*>(&dataVec[0]))));
   /*lint -restore */
}
