/*
 * \file        dia_TraceCmdPrintEventList.cpp
 *
 * \brief       {insert brief description here}
 * 
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Mar 13, 2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 */

// DIA_REQ CMD 0 B          (print default number of last events)
// DIA_REQ CMD 0 B 00 FF    (print last 255 events)
// DIA_REQ CMD 0 B 00 00    (print all available events)

#ifndef __INCLUDED_DIA_SERVICE_TRACKER__
#include "common/framework/platform/cca/dia_ServiceTracker.h"
#endif

#ifndef DIA_TRACECMDPRINTEVENTLIST_H_
#include "common/framework/trace/dia_TraceCmdPrintEventList.h"
#endif

#ifndef __INCLUDED_DIA_EVENT_LOGGER__
#include "common/framework/application/dia_EventLogger.h"
#endif

#define DIA_MAX_NUM_ITEMS           ((tU32)(0xFFFFFFFF))
#define DIA_DEFAULT_NUM_ITEMS       ((tU32)(100))

   // p = pMessage
   //              p0 p1 p2 p3 p4 (p5 p6)
   //                       |   |  |   |
   // (2 bytes) cmdID     --|-+-|  |   |
   //                              |   |
   // (2 bytes) numItems         --|-+-|

void dia_TraceCmdPrintEventList::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdPrintEventList::execute");
   tU32 numRequestedItems = 0;

   if ( (pMessage[0] != 4) && (pMessage[0] != 6) )
   {
      DIA_TR_ERR("dia_TraceCmdPrintEventList::execute Incorrect message length. Length = 0x%02x", pMessage[0]);
      return;
   }

   if (4==pMessage[0])
   {
      numRequestedItems = DIA_DEFAULT_NUM_ITEMS;
      DIA_TR_INF("dia_TraceCmdPrintEventList::execute Print default number of events: %d", numRequestedItems);
   }

   if (6==pMessage[0])
   {
      numRequestedItems = (((tU32)pMessage[5]<<8) + pMessage[6]);

      if (0==numRequestedItems)
      {
         DIA_TR_INF("dia_TraceCmdPrintEventList::execute Print ALL events from the list");
         numRequestedItems = DIA_MAX_NUM_ITEMS;
      }
      else
      {
         DIA_TR_INF("dia_TraceCmdPrintEventList::execute Print %d events from the list", numRequestedItems);
      }
   }

   dia_EventLogger* pEventLogger = getInstanceOfEventLogger();

   if (NULL!=pEventLogger)
   {
      pEventLogger->DumpEvents(numRequestedItems);
   }
   else
   {
      DIA_TR_ERR("dia_TraceCmdPrintEventList::execute NULL ptr");
   }
}
