/*
 * dia_TraceCmdExecuteRunIn.cpp
 *
 *  Created on: 08.01.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include "common/framework/engine/dia_ServiceDispatcher.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include "common/framework/engine/dia_EngineServerConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef DIA_TRACECMDEXECUTERUNIN_H_
#include <common/framework/trace/cmd/dia_TraceCmdExecuteRunIn.h>
#endif

#define DIA_MESSAGE_LEN (4)

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_RUNIN__
#include "common/framework/factory/dia_FactoryPluginRunIn.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_RUN_IN__
#include <common/framework/engine/dia_EngineRunIn.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_RUN_IN_CONFIGURATION__
#include <common/framework/engine/dia_EngineRunInConfiguration.h>
#endif

// p = pMessage
//               p0 p1 p2 p3 p4 p5
//                        |   |  |
// (2 bytes) cmdID      --|-+-|  |
// (1 byte)  sessionID  ---------|

void dia_TraceCmdExecuteRunIn::execute(const tU8* pMessage) const
{
   dia_tclFnctTrace oTrace("dia_TraceCmdExecuteRunIn::execute");

   if (DIA_MESSAGE_LEN != pMessage[0])
   {
      DIA_TR_ERR("dia_TraceCmdExecuteRunIn::execute Incorrect message length. Length = 0x%02x", pMessage[0]);
      DIA_TR_ERR("dia_TraceCmdExecuteRunIn::execute Expected message length is 4.");
      DIA_TR_INF("dia_TraceCmdExecuteRunIn::execute Usage #2: DIA_REQ CMD 0 14");
      return;
   }

   DIA_TR_ERR("############################################################");
   DIA_TR_ERR("#");
   DIA_TR_ERR("# START RUN-IN EXECUTION");
   DIA_TR_ERR("#");
   DIA_TR_ERR("############################################################");

   dia_EngineRunIn* pEngine = getInstanceOfFactoryPluginRunIn()->getEngine();
   if ( pEngine )
   {
      std::vector<tArgsType> vecArgs;
      if ( pEngine->startControl(vecArgs) != DIA_SUCCESS )
      {
         DIA_TR_ERR("### START OF RUNIN-ENGINE FAILED !!! ###");
      }
   }
}

