/*
 * dia_TraceCmdCRCDatadownload.cpp
 *
 *  Created on: 06.03.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_TRACE_CMD_CRC_DATADOWNLOAD__
#include "common/framework/trace/cmd/dia_TraceCmdCRCDatadownload.h"
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_MANAGER__
#include "common/framework/datadownload/dia_DataDownloadManager.h"
#endif

//-----------------------------------------
void
dia_TraceCmdCRCDatadownload::execute ( const tU8* pMessage ) const
 {
    dia_tclFnctTrace oTrace("dia_TraceCmdCRCDatadownload::execute");

    if ( !pMessage )
    {
       DIA_TR_ERR("dia_TraceCmdCRCDatadownload::execute : INVALID MESSAGE POINTER");
       return;
    }

    if ( getSizeInBytes(pMessage) != 5 )
    {
       DIA_TR_ERR("dia_TraceCmdCRCDatadownload::execute INVALID MESSAGE LENGTH (%d)", getSizeInBytes(pMessage));
       return;
    }

    dia_DataDownloadManager* pDnlMgr = getInstanceOfDataDownloadManager();
    pDnlMgr->setCrcMode((pMessage[5]) ? true : false);
 }
