/**
 * \file      dia_TestService.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 26, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_TEST_SERVICE__
#include "common/framework/test/dia_TestService.h"
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include "common/framework/protocols/uds/dia_MessageBufferUDS.h"
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER__
#include "common/framework/application/dia_CommandController.h"
#endif

#ifndef __INCLUDED_DIA_CMD_START_TEST__
#include "common/framework/test/dia_CmdStartTest.h"
#endif

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include "common/framework/test/dia_TestController.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include "common/framework/utils/dia_HashCalculator.h"
#endif


std::map<tU16,dia_TestService*> dia_TestService::mObjRep;


//-----------------------------------------------------------------------------

dia_TestService::dia_TestService ( tCString name )
   : dia_Test(name, DIA_EN_TEST_TYPE_SERVICE),
     dia_ServiceHandlerUDS(name),
     mEmbeddedMode(FALSE)
{}

//-----------------------------------------------------------------------------

dia_TestService::dia_TestService ( tCString name, tU8 sid, tU16 did )
   : dia_Test(name, DIA_EN_TEST_TYPE_SERVICE),
     dia_ServiceHandlerUDS(name, sid, (tU16) did),
     mEmbeddedMode(FALSE)
{
   mObjRep[did] = this;
}

//-----------------------------------------------------------------------------

dia_TestService::~dia_TestService ( void )
{}

//-----------------------------------------------------------------------------

void
dia_TestService::vOnTimeout ( void )
{
    dia_tclFnctTrace oTrace("dia_TestService::vOnTimeout()");
    testTerminate();
}

//-----------------------------------------------------------------------------

void
dia_TestService::testTerminate ( void )
{
   testDone();

   if ( mEmbeddedMode == FALSE )
   {
      vResReadyAndQuit();
   }
   else
   {
      mEmbeddedMode = FALSE;
   }
}

//-----------------------------------------------------------------------------

bool
dia_TestService::checkPreConditions ( void ) const
{
   dia_tclFnctTrace trc("dia_TestService::checkPreConditions");

   bool preConditionOK = true;
   std::list<dia_Predicate*>::const_iterator predIter = mpPredicateRep.begin();
   for ( ; predIter != mpPredicateRep.end(); ++predIter )
   {
      if ( *predIter && (!(*predIter)->checkPreConditions()) )
      {
         preConditionOK = false;
         break;
      }
   }

   DIA_TR_INF("dia_TestService::checkPreConditions returned %s.", (preConditionOK ? "true": "false"));

   return preConditionOK;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_TestService::run ( dia::UID /*condition*/ )
{
   dia_tclFnctTrace trc("dia_TestService::run");

   if ( !checkPreConditions() )
   {
      DIA_TR_INF("dia_TestService::run returned DIA_SUCCESS. Do nothing.");
      return DIA_SUCCESS;
   }

   tDiaResult retCode = DIA_FAILED;

   tU8 msgBuffer[4] = {4, DIA_C_U8_UDS_SID_DIAG_COMMAND, 0x00, 0x00};
   msgBuffer[2] = (tU8) (getDID() >> 8);
   msgBuffer[3] = (tU8) (getDID() & 0x00FF);

   // Create an object containing the UDS msg. It is deleted by dia_tclDiagSessionUds::ReadyForReqRx::OnEnter
   dia_MessageBufferUDS* pMsgBuff = OSAL_NEW dia_MessageBufferUDS (
       &msgBuffer[0],
       tU16(sizeof msgBuffer),
       vTestServiceTxOk,
       dia_MessageBufferUDS::holds_request_internal,
       dia_MessageBufferUDS::format_length_and_data,
       (tCookieType) this
       );  //lint !e429: custodial pointer is freed by after engine has processed the message

//   DIA_ASSERT(pMsgBuff);

   if (pMsgBuff)
   {
      dia_CmdStartTest* pCmd = OSAL_NEW dia_CmdStartTest(pMsgBuff); //lint !e429: custodial pointer is freed by after engine has processed the message
      if ( pCmd )
      {
         std::list<dia_Predicate*>::iterator iter = mpPredicateRep.begin();
         for ( ; iter != mpPredicateRep.end(); iter++ )
         {
            if ( *iter ) pCmd->addPredicate((*iter)->clone());
         }

         getInstanceOfCommandController()->addCommand(pCmd);
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_TestService::run - TEST UID=0x%08X NAME=%s SUCCESSFULLY TRIGGERED.", getTestUID(), getTestName());
      }
      else
      {
         DIA_TR_ERR("dia_TestService::run - TRIGGERING TEST UID=0x%08X TRIGGER FAILED!", getTestUID());
      }

      pCmd = 0;  //lint !e423 Warning: Creation of memory leak in assignment to 'pCmd'. --> lifetime is controlled by command controller
   } //lint !e438 Warning: last value assigned to variable not used

   // make lint happy
   pMsgBuff = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'poMsgBuffer'. --> lifetime is controlled by diagnostic session

   return retCode; //lint !e438 Warning: last value assigned to variable not used
}

//----------------------------------------------------------------------------

tVoid
dia_TestService::vTestServiceTxOk ( const tU8* /*data*/, tU16 /*len*/, tCookieType cookie )
{
    dia_tclFnctTrace trc("dia_TestService::vTestServiceTxOk");

    if ( cookie )
    {
//    if ( len < 4 )
//    {
//       DIA_TR_ERR("##### UNEXEPECTED DATA BUFFER LENGTH !!! (LEN = %d) #####", len);
//       // TODO: add further error handling here if required in the future
//       return;
//    }
//
//    if ( data[1] == 0x7F )
//    {
//       DIA_TR_ERR("##### TEST EXECUTION OF TEST HAS FAILED !!! (NRC = 0x%02x) #####", data[3]);
//       // TODO: add further error handling here if required in the future
//       return;
//    }
       dia_TestService* pObj = (dia_TestService*) cookie;
       tU16 did = pObj->getDID();

       //DIA_TR_INF("dia_TestService::vTestServiceTxOk did=0x%04X.", did);

       if ( did )
       {
          std::map<tU16,dia_TestService*>::iterator it = mObjRep.find(did);
          if ( it != mObjRep.end() )
          {
             //DIA_TR_INF("dia_TestService::vTestServiceTxOk did=0x%04X found in repository.", did);
             getInstanceOfTestController()->setTestDone(mObjRep[did]->getTestUID());
          }
          else
          {
             DIA_TR_ERR("##### did=0x%04X not found in repo. #####", did);
          }
       }
       else
       {
          DIA_TR_ERR("##### did=0x0000 #####");
       }
    }

    getInstanceOfApplication()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventConfTxOk());
}



