/*
 * dia_TestRunIn.h
 *
 *  Created on: 28.11.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_TEST_RUNIN__
#define __INCLUDED_DIA_TEST_RUNIN__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_TEST_SERVICE__
#include "common/framework/test/dia_TestService.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include "common/interfaces/dia_ITimerListener.h"
#endif

enum dia_enTestRunInOperationMode
{
   DIA_EN_TEST_RUNIN_OPERATION_MODE_UNKNOWN = 0,
   DIA_EN_TEST_RUNIN_OPERATION_MODE_SPAWN_TIMER,
   DIA_EN_TEST_RUNIN_OPERATION_MODE_START_EXECUTION,
   DIA_EN_TEST_RUNIN_OPERATION_MODE_COUNT
};

//-----------------------------------------------------------------------------

class dia_TestRunIn
   : public dia_TestService,
     public dia_ITimerListener
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_TestRunIn);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_TestRunIn);

public:
   //! process the received service (Read configuration data, calculate checksum and write it to registry)
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed ( dia_TimerID id );

protected:
   // one timer per session, used in the processing and post processing stage
   dia_Timer oTimer;
   //! current status of the test object as this test is triggered several times
   dia_enTestRunInOperationMode mode;
};

#endif /* __INCLUDED_DIA_TEST_RUNIN__ */
