/*
 * dia_TestRunIn.cpp
 *
 *  Created on: 28.11.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_TEST_RUNIN__
#include "common/framework/test/dia_TestRunIn.h"
#endif

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include "common/framework/test/dia_TestController.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_RUNIN__
#include "common/framework/factory/dia_FactoryPluginRunIn.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_RUN_IN__
#include <common/framework/engine/dia_EngineRunIn.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_RUN_IN_CONFIGURATION__
#include <common/framework/engine/dia_EngineRunInConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include <common/depricated/dia_main.h>
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif


#define DIA_C_U32_RUNIN_DEFAULT_START_DELAY  ((tU32) 60000)

//-----------------------------------------------------------------------------

dia_TestRunIn::dia_TestRunIn ( void )
   : dia_TestService("dia_TestRunIn", DIA_C_U8_UDS_SID_DIAG_COMMAND, DIA_C_U16_DID_RBCM_TEST_RUN_IN),
                     mode(DIA_EN_TEST_RUNIN_OPERATION_MODE_UNKNOWN)
{
   dia_tclFnctTrace oTrace("dia_TestRunIn::dia_TestRunIn()");

   if ( oTimer.s32Create() == OSAL_OK )
   {
       oTimer.addTimerListener(this);
   }
   else
   {
       DIA_TR_ERR("ERR: UNABLE TO SETUP RUNIN TIMER !!");
   }
}

//-----------------------------------------------------------------------------

dia_TestRunIn::~dia_TestRunIn ( void )
{
   _BP_TRY_BEGIN
   {
      (void) oTimer.s32Delete();
       oTimer.removeTimerListener(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_TestRunIn::~dia_TestRunIn !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
dia_TestRunIn::vOnTimerElapsed ( dia_TimerID /*id*/ )
{
    testDone();
   (void) getInstanceOfApplication()->postMessage(DIA_EVENT_START_RUNIN);
}

//-----------------------------------------------------------------------------

void
dia_TestRunIn::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_TestRunIn::vProcessRequest()");

   if ( mode == DIA_EN_TEST_RUNIN_OPERATION_MODE_UNKNOWN )
   {
      tU8 opMode = 0;
      (void) dia_getProperty(DIA_PROP_CM_RUN_IN_ACTIVATION,opMode);

      if ( opMode == 1 )
      {
         tU32 startDelay = DIA_C_U32_RUNIN_DEFAULT_START_DELAY;
         if ( dia_getProperty(DIA_PROP_CM_RUN_IN_START_DELAY,startDelay) != DIA_SUCCESS )
         {
            startDelay = DIA_C_U32_RUNIN_DEFAULT_START_DELAY;
         }

         DIA_TR_ERR("############################################################");
         DIA_TR_ERR("#");
         DIA_TR_ERR("### START RUN-IN-TIMER (DELAY = %d seconds)",startDelay);
         DIA_TR_ERR("#");
         DIA_TR_ERR("############################################################");

         mode = DIA_EN_TEST_RUNIN_OPERATION_MODE_SPAWN_TIMER;

         oTimer.addTimerListener(this);
         oTimer.s32SetTime(startDelay,0);
      }
   }
   else if ( mode == DIA_EN_TEST_RUNIN_OPERATION_MODE_SPAWN_TIMER )
   {
      oTimer.s32SetTime(0,0);
      oTimer.removeTimerListener(this);

      tU8 opMode = 0;
      (void) dia_getProperty(DIA_PROP_CM_RUN_IN_ACTIVATION,opMode);

      if ( opMode == 1 )
      {
         DIA_TR_ERR("############################################################");
         DIA_TR_ERR("#");
         DIA_TR_ERR("# START RUN-IN EXECUTION");
         DIA_TR_ERR("#");
         DIA_TR_ERR("############################################################");

         // run-in was not deactivated, so we have to start the run-in
         tDiaResult retCode = getInstanceOfFactoryPluginRunIn()->setup(DIA_EN_INITLEVEL_ALL);
         if ( retCode == DIA_SUCCESS )
         {
            DIA_TR_INF("### RUN-IN-ENGINE STARTED SUCCESSFULLY ###");
         }
         else
         {
            DIA_TR_ERR("### FAILED TO START RUN-IN-ENGINE (ERRCODE = 0x%08x", retCode);
         }
      }
      else
      {
         DIA_TR_ERR("############################################################");
         DIA_TR_ERR("#");
         DIA_TR_ERR("# RUN-IN EXECUTION REJECTED -- (DEACTIVATED)");
         DIA_TR_ERR("#");
         DIA_TR_ERR("############################################################");
      }
   }

   testTerminate();
}
