/**
 * \file      dia_TestCalcHashUpdateRegistry.cpp
 *
 * \brief
 *
 * \details
 *
 * \author    kaa1hi
 * \date      Nov 12, 2015
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */


#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_TEST_CALC_HASH_UPDATE_REGISTRY_H_
#include "dia_TestCalcHashUpdateRegistry.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_EXT_DIAGLOG_IF__
#include "project/framework/application/ext_diaglog_if.h"      //label for ITC
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG__
#include "common/interfaces/dia_IErrorLog.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif


using namespace std;

//-----------------------------------------------------------------------------

dia_TestCalcHashUpdateRegistry::dia_TestCalcHashUpdateRegistry ( tCString name, tU16 testID, tU32 propResultHashLongFormat  )
   : dia_TestService( name, DIA_C_U8_UDS_SID_DIAG_COMMAND, testID),
                     mPropResultHashLongFormat(propResultHashLongFormat)
{
   dia_tclFnctTrace oTrace("dia_TestCalcHashUpdateRegistry::dia_TestCalcHashUpdateRegistry()");
}

//-----------------------------------------------------------------------------

dia_TestCalcHashUpdateRegistry::~dia_TestCalcHashUpdateRegistry ( void )
{
}

void
dia_TestCalcHashUpdateRegistry::setPropData(const dia_FingerprintInfo* pPropData, const tU16 sizeOfArray)
{
   DIA_TR_INF("dia_TestCalcHashUpdateRegistry::setPropData() sizeOfArray=%d", sizeOfArray);

   mVectPropData.clear();
   for (tU16 i=0; i<sizeOfArray; i++)
   {
      mVectPropData.push_back(pPropData[i].mProperty);
   }
}

void
dia_TestCalcHashUpdateRegistry::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_TestCalcHashUpdateRegistry::vProcessRequest()");

   std::vector<tU8> configData;
   std::vector<tU8> Hash;

   // read all configuration items and append to output buffer
   if (DIA_SUCCESS!=dia_nsUtilities::readConfiguration(mVectPropData, configData))
   {
      DIA_TR_ERR("### dia_TestCalcHashUpdateRegistry::vProcessRequest() NOT ALL CONFIGURATION ITEMS WAS READ ###");
      DIA_TR_ERR("### DESPITE THE READING ERROR PLEASE CONTINUE ###");
   }

   if (!configData.empty())
   {
      if (false==dia_nsUtilities::generateHash(configData, Hash))
      {
         DIA_TR_ERR("dia_TestCalcHashUpdateRegistry::vProcessRequest() generateHash FAILED");
         if (DIA_SUCCESS!=dia_nsUtilities::writeHashLongFormatToRegistry(NULL, mPropResultHashLongFormat))
         {
            DIA_TR_ERR("### dia_TestCalcHashUpdateRegistry::vProcessRequest() REGISTER NOT UPDATED ###");
         }
         testTerminate();
         return;
      }
   }
   else
   {
      DIA_TR_ERR("dia_TestCalcHashUpdateRegistry::vProcessRequest() ERROR. Size of new hash is 0.");
      if (DIA_SUCCESS!=dia_nsUtilities::writeHashLongFormatToRegistry(NULL, mPropResultHashLongFormat))
      {
         DIA_TR_ERR("### dia_TestCalcHashUpdateRegistry::vProcessRequest() REGISTER NOT UPDATED ###");
      }
      testTerminate();
      return;
   }

   if ( DIA_CONFIG_HASH_BINARY_SIZE != Hash.size())
   {
      DIA_TR_ERR("dia_TestCalcHashUpdateRegistry::vProcessRequest() ERROR: newBinHash.size()=%zu", Hash.size());
      if (DIA_SUCCESS!=dia_nsUtilities::writeHashLongFormatToRegistry(NULL, mPropResultHashLongFormat))
      {
         DIA_TR_ERR("### dia_TestCalcHashUpdateRegistry::vProcessRequest() REGISTER NOT UPDATED ###");
      }
      testTerminate();
      return;
   }

   // conversion to format "{00112233-00112233-00112233-00112233-00112233}"
   string strHash;
   dia_nsUtilities::convertToHashSpecificFormat(Hash, strHash);

   DIA_TR_INF("dia_TestCalcHashUpdateRegistry::vProcessRequest() Hash=%s", dia_nsUtilities::convertArray2HexString(Hash).c_str() );
   DIA_TR_INF("dia_TestCalcHashUpdateRegistry::vProcessRequest() strHash=%s", strHash.c_str() );

   //copy string content to tU8 buffer
   tU8 buffHashLongFormat[DIA_CONFIG_HASH_STRING_LONG_FORMAT_SIZE] = {0};
   tU8* strBuff = NULL;

   if (strHash.size()==(DIA_CONFIG_HASH_STRING_LONG_FORMAT_SIZE-1))
   {
      size_t length = strHash.copy( reinterpret_cast<char*>(buffHashLongFormat), (DIA_CONFIG_HASH_STRING_LONG_FORMAT_SIZE-1) );

      //robust check
      if (length<DIA_CONFIG_HASH_STRING_LONG_FORMAT_SIZE)
      {
         buffHashLongFormat[length] = '\0';
         strBuff = (tU8*)&buffHashLongFormat[0];
      }
      else
      {
         DIA_TR_ERR("ERROR. length=%zu is not less than buffer size (%d)", length, DIA_CONFIG_HASH_STRING_LONG_FORMAT_SIZE);
      }

      DIA_TR_INF("dia_TestCalcHashUpdateRegistry::vProcessRequest() length=%zu", length);
   }
   else
   {
      DIA_TR_ERR("ERROR. strHash.size()=%zu is not %d", strHash.size(), (DIA_CONFIG_HASH_STRING_LONG_FORMAT_SIZE-1) );
   }

   if (DIA_SUCCESS!=dia_nsUtilities::writeHashLongFormatToRegistry( strBuff, mPropResultHashLongFormat))
   {
     DIA_TR_ERR("### dia_TestCalcHashUpdateRegistry::vProcessRequest() REGISTER NOT UPDATED ###");
   }

   testTerminate();
}

//-----------------------------------------------------------------------------

void
dia_TestCalcHashUpdateRegistry::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_TestCalcHashUpdateRegistry::vOnTimeout()");
   testTerminate();
}
